var _ = require('underscore'),
    Backbone = require('backbone'),
    Marionette = require('marionette'),
    beAdapter = require('beAdapter');

// Mustache-like синтаксис
_.templateSettings = {
  interpolate: /\{\{(.+?)\}\}/g
};

var delegateEventSplitter = /^(\S+)\s*(.*)$/;

module.exports = {
    getTemplate: function() {
        var tpl = Marionette.getOption(this, 'template');

        return _.template(tpl);
    },

    // Копи-паста из Marionette + BEM
    bindUIElements: function() {
        if (!this.ui) { return; }

        // store the ui hash in _uiBindings so they can be reset later
        // and so re-rendering the view will be able to find the bindings
        if (!this._uiBindings){
          this._uiBindings = this.ui;
        }

        // get the bindings result, as a function or otherwise
        var bindings = _.result(this, '_uiBindings');

        // empty the ui so we don't have anything to start with
        this.ui = {};

        // bind each of the selectors
        _.each(_.keys(bindings), function(key) {
            var selector = bindings[key];

            if (typeof selector === 'string') { // Marionette Binding
                this.ui[key] = this.$(selector);
            } else if (selector instanceof Array) { // BEM binding
                this.ui[key] = beAdapter(this.$(selector[0]), selector[1]);
            } else {
                throw new Error('UI value wrong type');
            }
          
        }, this);

        // на бем элементы можно делегировать события только после появления элементов в доме :(
        this._delegateBEMEvents();
      },

    // Копи-паста из Marionette + BEM
    normalizeUIKeys: function(hash) {
        if (typeof(hash) === 'undefined') {
          return;
        }

        var proto = Object.getPrototypeOf(this);
        proto._bemEvents = proto._bemEvents || {};

        _.each(_.keys(hash), function(v) {
            var split = v.split('@ui.'),
                selector;

            if (split.length === 2) {
                  selector = this.ui[split[1]];
                  if (typeof selector === 'string') { // Marionette Binding
                      hash[split[0] + selector] = hash[v];
                  } else if (selector instanceof Array) { // BEM binding
                      this._bemEvents[split[0] + split[1]] = hash[v];
                  } else {
                      throw new Error('Event selector wrong type');
                  }
                  delete hash[v];
            }
        }, this);

        return hash;
    },

    // Копи-паста из Marionette + BEM
    undelegateEvents: function() {
        // Сначала бем
        this._undelegateBEMEvents();

        // Потом Marionette
        var args = Array.prototype.slice.call(arguments);
        Backbone.View.prototype.undelegateEvents.apply(this, args);

        Marionette.unbindEntityEvents(this, this.model, Marionette.getOption(this, 'modelEvents'));
        Marionette.unbindEntityEvents(this, this.collection, Marionette.getOption(this, 'collectionEvents'));
    },

    _delegateBEMEvents: function() {
        _.each(this._bemEvents, function(method, key) {
            var match = key.match(delegateEventSplitter),
                eventName = match[1],
                uiName = match[2];

            if (!_.isFunction(method)) {
                method = this[method];
            }

            this.ui[uiName].on(eventName, _.bind(method, this));
        }, this);
    },

    _undelegateBEMEvents: function() {
        if (!this.ui || !this._uiBindings) {
            return;
        }

        _.each(this._bemEvents, function(method, key) {
            var match = key.match(delegateEventSplitter),
                eventName = match[1],
                uiName = match[2];

            this.ui[uiName].un(eventName);
        }, this);
    }
};
