var _ = require('underscore'),
    Backbone = require('Backbone'),
    geo = require('geo');


function metric(q, p) {
    return Math.sqrt(Math.pow(q[0] - p[0], 2) + Math.pow(q[1] - p[1], 2));
}

var GeoCollection = Backbone.Collection.extend({
    getBounds: function() {
        if (this.length === 1) {
            var center = [this.models[0].get('lon'), this.models[0].get('lat')];

            return geo.center2Bounds(center);
        }

        var lons = this.pluck('lon'),
            lats = this.pluck('lat'),
            result = [[_.min(lons), _.min(lats)], [_.max(lons), _.max(lats)]];

        if (!this.length || _.flatten(result).indexOf(null) !== -1) {
            return false;
        }

        return result;
    },

    findClosest: function(coords, maxDistance, precise) {
        var pixelCoords = geo.geoCoords2Pixels(coords, precise),
            closest = null;

        closest = this.min(function(model) {
            var distance = metric(pixelCoords, geo.geoCoords2Pixels(model.getCoords(), precise));
            if (distance <= maxDistance) {
                return distance;
            }
        });

        if (closest !== Infinity) {
            return closest;
        }
    }
});

module.exports = GeoCollection;
