// View главным элементом которой является Select
// Правильно выставляет дефолтное значение, реагирует на события модели
// И пробрасывает события изменения
module.exports = {
    events: {
        'change @ui.select': 'onChange',
    },

    collectionEvents: {
        'reset': 'updateOptions',
        'change': 'updateOptions',
        'remove': '_onRemove'
    },

    initialize: function(options) {
        this.selectInit(options);
    },

    selectInit: function(options) {
        this.value = options.value;
    },

    setModel: function(model) {
        if (this.model && this.model === model) {
            return;
        }

        this.model = model;

        this.trigger('changeSelected', {
            model: this.model,
            collection: this.collection,
            view: this
        });

        this.value = model.id;
    },

    onRender: function() {
        this.updateOptions();
    },

    onChange: function(e, data) {
        var idx, model;

        // При select.setOptions кидается onChange с { index: 0, prev: -1}
        // даже если есть init значение
        if (data.prev === -1 && this.value) {
            idx = this.collection.indexOf(this.collection.get(+this.value));
            if (idx === -1) {
                data.index = 0;
            } else if (idx !== 0) {
                return;
            }
        }

        model = this.collection.at(data.index);

        this.setModel(model);
    },

    _onRemove: function(model) {
        if (parseInt(this.value, 0) === model.get('id')) {
            this.value = undefined;
        }
        this.updateOptions();
    },

    updateOptions: function() {
        var data = this.collection.map(function(item) {
                return { item: 'option', value: item.get('id'), content: item.get('title') };
            });

        this.ui.select.setOptions(data, this.value);
    },

    val: function(model) {
        this.ui.select.val('' + model.id);
    }
};
