var _ = require('underscore'),
    BemItemView = require('common/bemItemView'),
    makeOptions = require('makeOptions');

var NewSettlementForm = BemItemView.extend({
    template: require('templates/settlement-form-new'),

    ui: {
        headerTitle: '.island__title',
        headerToggle: '.island__toggle',

        title: ['.js-title', 'input'],
        country: ['.js-country', 'related-object'],
        region: ['.js-region', 'related-object'],
        majority: ['.js-majority', 'select'],
        timeZone: ['.js-time-zone', 'select'],

        cancel: ['.js-cancel', 'button'],
        create: ['.js-create', 'button']
    },

    events: {
        'click @ui.cancel': 'close',
        'click @ui.create': 'create',
    },

    onRender: function() {
        this.ui.headerTitle.text(gettext('Новый город'));
        this.ui.headerToggle.remove();

        this.ui.majority.setOptions(makeOptions('city_majorities'));
        this.ui.timeZone.setOptions(makeOptions('time_zones'));

        setTimeout(_.bind(function () {
            this.ui.majority.redraw();
            this.ui.timeZone.redraw();
        }, this), 0);
    },

    create: function() {
        this.model.set({
            'title': this.ui.title.val(),
            'time_zone': this.ui.timeZone.val()
        });

        _.map(['country', 'region', 'majority'], function (field) {
            var value = this.ui[field].val();
            this.model.set(field + '_id', value ? parseInt(value, 10) : null);
        }, this);

        this.trigger('create', this.model);
    }
});

module.exports = NewSettlementForm;
