var _ = require('underscore');


var Maps = function(options) {
    this.initialize(options);
};

_.extend(Maps.prototype, {

    initialize: function(options){
        this.app = options.app;
        this.controls = [];
        this.mapTools = [];

        if (options.mapTools) {
            this.mapTools = this.mapTools.concat(options.mapTools);
        }

        if (options.controls) {
            this.controls = this.controls.concat(options.controls);
        }

        this._buildMap();
        this.bind();

        this.app.map = this.map;
        this.app.trigger('maps:initialized');
    },

    bind: function() {
        this.app.on('maps:setCenter', _.debounce(function() {
            this.map.setCenter.apply(this.map, arguments);
        }, 200), this);

        this.app.on('maps:setBounds', _.debounce(function() {
            this.map.setBounds.apply(this.map, arguments);
        }, 200), this);

        this.app.on('maps:preciseMode', function (preciseMode) {
            this.preciseMode = preciseMode;
        }, this);
    },

    on: function(name, callback, context) {
        this.map.events.add(name, callback, context);
    },

    off: function(name, callback, context) {
        this.map.events.remove(name, callback, context);
    },

    _buildMap: function() {
        this.map = new ymaps.Map('maps', {
            center: [37.64, 55.76], // Москва
            zoom: 10,
            // включаем масштабирование карты колесом
            behaviors: ['default', 'scrollZoom'],
            type: 'yandex#map',
            controls: []
        });
    },

    addControls: function() {
        _.each(this.mapTools, function (tool) {
            if (_.isFunction(tool)) {
                tool = tool();
            } else if (_.isString(tool)) {
                var parts = tool.split('.');
                tool = _.reduce(parts, function (module, key) {
                    return module[key];
                }, this.app.modules);
            }

            this.controls.push(tool);
        }, this);

        _.each(this.controls, function (control) {
            if (_.isFunction(control)) {
                control = control();
            }

            this.map.controls.add(control);
        }, this);

        this.map.controls.add('typeSelector', {
            float: 'none',
            position: {
                top: 45,
                left: 10
            }
        }).add('searchControl', {
            float: 'none',
            position: {
                top: 45,
                left: 110
            }
        }).add('zoomControl').add('rulerControl');
    }

});

module.exports = Maps;
