var Marionette = require('marionette'),
    SidebarView = require('modules/blue_original_data/sidebarView');

var OriginalDataController = Marionette.Controller.extend({
    initialize: function(options) {
        this.app = options.app;
    },

    // Блоки
    infoBlock: function(region) {
        this._infoBlockRegion = region;
        this.listenTo(this.app, 'thread:changed', this._showBlock, this);
    },

    _showBlock: function(options) {
        options = options || {};

        var model = options.model,
            view;

        if (!model || !model.get('originalThreads') || !model.get('originalThreads').length) {
            this._infoBlockRegion.close();
            return;
        }

        view = new SidebarView({
            model: options.model
        });

        this._infoBlockRegion.show(view);
    }
});

module.exports = OriginalDataController;
