var Marionette = require('marionette'),
    BackboneYmaps = require('Backbone.Ymaps'),
    StationCollection = require('modules/blue_stations/collection'),
    SidebarView = require('modules/blue_stations/sidebarView'),
    StationPlacemark = require('modules/blue_stations/placemark');

var StationsController = Marionette.Controller.extend({
    initialize: function(options) {
        this.sidebarView = null;
        this.app = options.app;
        this.initValue = options.moduleOptions.packages.id;
        this.collection = new StationCollection();

        this.listenTo(this.app, 'thread:changed', this.setThread, this);
        this.listenTo(this.collection, 'reset', this._updateBounds, this);

        this._renderMapLayout();
    },

    // Api
    setThread: function(options) {
        this.collection.setThread(options.model);
        this.collection.fetch({reset: true});
    },

    // Private
    _renderMapLayout: function() {
        var layer = new BackboneYmaps.CollectionView({
            geoItem: StationPlacemark,
            collection: this.collection,
            map: this.app.map
        });

        layer.render();
    },

    _updateBounds: function() {
        var bounds = this.collection.getBounds();
        if (!bounds) {
            var center = this.app.currentPackage.get('center') || [37.64, 55.76];
            this.app.trigger('maps:setCenter', center);
            return;
        }

        this.app.trigger('maps:setBounds', bounds);
    },

    // Блоки
    selectBlock: function(region) {
        this.sidebarView = new SidebarView({
            collection: this.collection
        });

        region.show(this.sidebarView);
    }
});

module.exports = StationsController;
