var app = require('app'),
    _ = require('underscore'),
    Marionette = require('marionette'),
    BemCompositeView = require('common/bemCompositeView'),
    StationView = require('modules/blue_stations/sidebarItemView');


var EmptyView = Marionette.ItemView.extend({
    template: function() {
        return gettext('Нет станций');
    }
});

var StationsView = BemCompositeView.extend({
    template: require('templates/stations-control'),

    itemView: StationView,
    emptyView: EmptyView,
    itemViewContainer: '.list',

    ui: {
        autoplace: ['.js-autoplace', 'button'],
        autocreate: ['.js-autocreate', 'button'],
        saveSetting: ['.js-save-setting', 'button'],
        settingFormImport: ['.js-thread-setting-form .js-import', 'radio-button'],
        settingFormBaseStations: ['.js-thread-setting-form .js-base-stations', 'radio-button'],
        settingFormTimezoneOverride: ['.js-thread-setting-form .js-time-zone-override', 'select'],
    },

    events: {
        'click @ui.autoplace': 'autoplace',
        'click @ui.autocreate': 'autocreate',
        'click @ui.saveSetting': 'saveSetting'
    },

    initialize: function() {
        this.listenTo(this.collection, 'reset', this.updateThreadForm, this);
    },

    updateThreadForm: function() {
        var thread = this.collection.thread,
            setting;

        if (thread) {
            setting = thread.get('setting');

            this.ui.settingFormImport.val(setting['allow_to_import'] ? 'yes' : 'no');
            this.ui.settingFormBaseStations.val(setting['apply_base_stations'] ? 'yes' : 'no');
            this.ui.settingFormTimezoneOverride.val(setting['timezone_override']);
        }
    },

    saveSetting: function() {
        var thread = this.collection.thread,
            setting;
        if (!thread) { return; }

        setting = thread.get('setting');

        setting['allow_to_import'] = this.ui.settingFormImport.val() === 'yes';
        setting['apply_base_stations'] = this.ui.settingFormBaseStations.val() === 'yes';
        setting['timezone_override'] = this.ui.settingFormTimezoneOverride.val();

        this.ui.saveSetting.setMod('disabled', 'yes');

        thread.saveSetting().always(function() {
            this.ui.saveSetting.delMod('disabled');
        }.bind(this));
    },

    onRender: function() {
        var options = _.map(
            app.config['timezone_override_choices'],
            function(pair) {
                return { item: 'option', value: pair[0], content: pair[1] };
            }
        );

        // Блок еще не в DOM, потому для нормальной работы live делаем setTimeout
        setTimeout(function() {
            var thread = this.collection && this.collection.thread,
                value = thread && thread.get('setting')['timezone_override'];

            this.ui.settingFormTimezoneOverride.setOptions(options, value || 'none');
        }.bind(this), 0);
    },

    autoplace: function() {
        this.collection.resetUnplaced();
        this.collection.fillMissedGeo();
    },

    autocreate: function() {
        var unmappedModels = this.collection.filter(function(model) {
            return !model.isWwwPlaced() && model.get('placed');
        });

        if (!unmappedModels.length) {
            return;
        }

        var country = app.currentPackage.get('country') || {},
            region = app.currentPackage.get('region') || {},
            question = [gettext('Создать станции в')];

        region.title && question.push(region.title);
        country.title && question.push(country.title);
        question = question.join(' ') + '?';

        if (!confirm(question)) {
            return;
        }

        var options = {
            'country_id': country.id,
            'region_id': region.id,

            'majority_id': app.config.defaults.majority,
            'station_type_id': app.config.defaults.stationType,
            't_type_id': app.config.defaults.transportType
        };

        _.each(unmappedModels, function(model) {
            model.createWwwStation(options);
            model.save();
        });
    }
});

module.exports = StationsView;
