var app = require('app'),
    _ = require('underscore'),
    BemItemView = require('common/bemItemView'),
    makeOptions = require('makeOptions');

var StationForm = BemItemView.extend({
    template: require('templates/station-form'),

    ui: {
        country: ['.js-country', 'related-object'],
        region: ['.js-region', 'related-object'],
        district: ['.js-district', 'related-object'],
        settlement: ['.js-settlement', 'related-object'],

        title: ['.js-title', 'input'],
        geocodeTitle: ['.js-geocode-title', 'input'],

        majority: ['.js-majority', 'select'],
        stationType: ['.js-station-type', 'select'],
        transportType: ['.js-transport-type', 'select'],

        threadUrl: '.js-thread-url',

        geocode: ['.js-geocode', 'button'],
        cancel: ['.js-cancel', 'button'],
        create: ['.js-create', 'button']
    },

    events: {
        'click @ui.cancel': 'cancel',
        'click @ui.create': 'create',
        'click @ui.geocode': 'geocode',
    },

    templateHelpers: function() {
        var threadUrl = '/admin/importinfo/twostageimportthread/?threadstations__station=';

        return {
            threadUrl: threadUrl + this.model.get('id')
        };
    },

    onRender: function() {
        var attrs = {
                country: app.currentPackage.get('country'),
                region: app.currentPackage.get('region'),
                settlement: null
            },
            transportTypeId = app.modules.wwwStations.selectedType || app.config.defaults.transportType;

        // Страна/Регион
        _.each(attrs, function(v, name) {
            var attr = this.model.get(name) || attrs[name] || {
                id: '',
                title: ''
            };

            this.ui[name].val(attr.id, attr.title);
        }, this);

        // Title
        this.ui.title.val(this.model.get('title'));
        this.ui.geocodeTitle.val(this.model.get('geocode_title') || this.model.get('title'));

        // Majority
        this.ui.majority.setOptions(makeOptions('station_majorities'), app.config.defaults.majority);

        // Station type
        this.ui.stationType.setOptions(
            makeOptions('station_types', 'name'),
            this._getStationTypeByTransportType(transportTypeId)
        );

        // Transport type
        this.ui.transportType.setOptions(makeOptions('t_types'), transportTypeId);
    },

    cancel: function() {
        this.trigger('close');
    },

    create: function() {
        var options = {
                title: this.ui.title.val(),

                'country_id': this.ui.country.val(),
                'region_id': this.ui.region.val(),
                'district_id': this.ui.district.val(),
                'settlement_id': this.ui.settlement.val(),

                'majority_id': this.ui.majority.val(),
                'station_type_id': this.ui.stationType.val(),
                't_type_id': this.ui.transportType.val()
            };

        this.model.createWwwStation(options);
        this.model.save();

        this.trigger('close');
    },

    geocode: function() {
        this.model.set('geocode_title', this.ui.geocodeTitle.val());
        $.get('/admin/blue/geocode/', {
            'geocode': this.model.get('geocode_title')
        }, _.bind(function(response) {
            if (response.status === 'ok') {
                _.each(['settlement', 'region', 'country', 'lon', 'lat'], function(key) {
                    this.model.set(key, response.geoobject[key]);
                }, this);

                this.trigger('coordinatesChanged');
            } else {
                alert('Не удалось прогеокодировать');
            }
        }, this));

    },

    _getStationTypeByTransportType: function(id) {
        return app.config.stationTypesByTransport[id] || app.config.defaults.stationType;
    }
});

module.exports = StationForm;
