var app = require('app'),
    Backbone = require('Backbone'),
    ThreadModel = require('modules/blue_threads/model');

var ThreadCollection = Backbone.Collection.extend({
    model: ThreadModel,
    comparator: function(a, b) {
        var delta = b.get('unmapped') - a.get('unmapped');
        if (delta === 0) {
            return a.get('title').localeCompare(b.get('title'));
        }
        return delta;
    },

    url: function() {
        return app.config.threadsUrl;
    },

    setPackage: function(package) {
        this.package = package;
    },

    fetch: function(options) {
        options = options || {};
        options.data = options.data || {};
        options.data['package_id'] = this.package.id;

        return Backbone.Collection.prototype.fetch.call(this, options);
    }
});

module.exports = ThreadCollection;
