var app = require('app'),
    Backbone = require('Backbone'),
    geo = require('geo');

var ThreadModel = Backbone.Model.extend({
    getTitle: function() {
        if (this.get('unmapped')) {
            return '# ' + this.get('title') + ' (' + this.get('unmapped') + ') #';
        }
        return this.get('title');
    },

    getBounds: function() {
        var center = this.collection.package.get('center') || [37.64, 55.76];

        return geo.center2Bounds(center);
    },

    saveSetting: function() {
        var self = this,
            options;

        options = {
            type: 'PUT',
            contentType: 'application/json; charset: utf-8',
            data: JSON.stringify(self.get('setting')),
            url: app.config.threadsUrl + 'save-setting/',
            success: function(res) {
                self.set('setting', res);
            }
        };

        return Backbone.ajax(options);
    }
});

module.exports = ThreadModel;
