var BemItemView = require('common/bemItemView'),
    selectItemViewMixin = require('common/selectItemViewMixin'),
    Base = BemItemView.extend(selectItemViewMixin);


var ThreadsView = Base.extend({
    template: require('templates/threads-control'),

    ui: {
        select: ['.js-thread', 'select'],
        nextButton: ['.js-next', 'button'],
        nextUnmappedButton: ['.js-next-unmapped', 'button']
    },

    events: {
        'change @ui.select': 'onChange',
        'click @ui.nextButton': 'nextThread',
        'click @ui.nextUnmappedButton': 'nextUnmapped'
    },

    updateOptions: function() {
        var data = this.collection.map(function(thread) {
                return { item: 'option', value: thread.get('id'), content: thread.getTitle() };
            });

        this.ui.select.setOptions(data, this.value);
    },

    nextThread: function() {
        var currentIndex = this.collection.indexOf(this.model);
        if (currentIndex >= this.collection.length - 1) {
            return;
        }

        this.ui.select.val('' + this.collection.at(currentIndex + 1).get('id'));
    },

    nextUnmapped: function() {
        var currentIndex = this.collection.indexOf(this.model),
            model,
            nextModel,
            i;

        for (i = currentIndex + 1; i < this.collection.length; i++) {
            model = this.collection.at(i);
            if (model.get('unmapped') > 0) {
                nextModel = model;
                break;
            }
        }

        if (nextModel === undefined) {
            alert(gettext('Не найдено других ниток с непривязанными станциями'));
            return;
        }

        this.ui.select.val('' + nextModel.get('id'));
    }
});

module.exports = ThreadsView;
