var app = require('app'),
    BemItemView = require('common/bemItemView');

var View = BemItemView.extend({
    template: require('templates/settlement-control'),

    ui: {
        input: ['.js-settlement', 'input'],
        addButton: ['.js-add', 'button'],
        editButton: ['.js-edit', 'button']
    },

    events: {
        'select @ui.input': '_onSelect',
        'change @ui.input': '_onChange',
        'click @ui.editButton': 'edit',
        'click @ui.addButton': 'add'
    },

    onRender: function() {
        this._updateAddButton();
    },

    set: function(id, text) {
        this._id = id;

        this._ignoreChange = true;
        this.ui.input.onFirst('change', function () {
            this._ignoreChange = false;
        }, this);

        this.ui.input.val(text || '');

        this._updateEditButton();
    },

    edit: function() {
        window.open(this._editUrl(this._id), '_blank');
    },

    add: function() {
        window.open(app.config.settlementAddUrl, '_blank');
    },

    _onSelect: function(sender, options) {
        this.trigger('changeSelected', options.item.params.id);
    },

    _onChange: function () {
        if (this._ignoreChange) {
            return;
        }

        this._id = null;
        this._updateEditButton();

        this.trigger('reset');
    },

    _editUrl: function (id) {
        return '/admin/www/settlement/' + id + '/';
    },

    _updateAddButton: function() {
        if (app.config.settlementAddUrl) {
            this.ui.addButton.delMod('disabled');
        } else {
            this.ui.addButton.setMod('disabled', 'yes');
        }
    },

    _updateEditButton: function() {
        if (this._id) {
            this.ui.editButton.delMod('disabled');
        } else {
            this.ui.editButton.setMod('disabled', 'yes');
        }
    }
});

module.exports = View;
