var Marionette = require('marionette'),
    PackageCollection = require('modules/packages/collection'),
    PackagesView = require('modules/packages/view');

var PackagesController = Marionette.Controller.extend({
    initialize: function(options) {
        this.app = options.app;
        this.initValue = options.moduleOptions.packages.id;
        this.collection = new PackageCollection();
        this.collection.fetch({reset: true});
    },

    selectBlock: function(region) {
        var view = new PackagesView({
            collection: this.collection,
            value: this.initValue
        });

        this.listenTo(view, 'changeSelected', function(options) {
            this.app.currentPackage = options.model;
            this.app.trigger('package:changed', options);
        }, this);

        region.show(view);
    }
});

module.exports = PackagesController;
