var BemItemView = require('common/bemItemView'),
    makeOptions = require('makeOptions'),
    setFuzzy = require('fuzzy');

var StationForm = BemItemView.extend({
    template: require('templates/metastation-form'),

    ui: {
        id: '.js-id',
        title: '.js-title',
        adminLink: '.js-admin-link',
        majority: ['.js-majority', 'select'],

        fuzzy: ['.js-fuzzy', 'radio-button'],
        searchableFrom: ['.js-searchable-from', 'radio-button'],
        searchableTo: ['.js-searchable-to', 'radio-button'],
        schedule: ['.js-station-schedule', 'radio-button'],
        fuzzyValue: ['.js-fuzzy-value', 'radio-value'],
        searchableFromValue: ['.js-searchable-from-value', 'radio-value'],
        searchableToValue: ['.js-searchable-to-value', 'radio-value'],
        scheduleValue: ['.js-station-schedule-value', 'radio-value'],

        saveButton: ['.js-save', 'button'],
        unmapButton: ['.js-unmap', 'button']
    },

    events: {
        'click @ui.saveButton': 'save',
        'click @ui.unmapButton': 'unmap'
    },

    templateHelpers: function() {
        return {
            adminUrl: this.model.get('www_station').getAdminUrl()
        };
    },

    onRender: function() {
        // Majority
        this.ui.majority.setOptions(
            makeOptions('station_majorities'),
            this.model.get('www_station').get('majority_id')
        );

        // Fuzzy
        if (this.model.get('first')) {
            this.ui.fuzzy.domElem.parent().parent().hide();
        }
        setFuzzy(this.model, this.ui, 'fuzzy', 'is_fuzzy');
        setFuzzy(this.model, this.ui, 'searchableFrom', 'is_searchable_from');
        setFuzzy(this.model, this.ui, 'searchableTo', 'is_searchable_to');
        setFuzzy(this.model, this.ui, 'schedule', 'in_station_schedule');
    },

    save: function() {
        var wwwModel = this.model.get('www_station');

        wwwModel.set('majority_id', +this.ui.majority.val());
        this.model.set({
            'is_fuzzy': this.ui.fuzzy.val(),
            'is_searchable_from': this.ui.searchableFrom.val(),
            'is_searchable_to': this.ui.searchableTo.val(),
            'in_station_schedule': this.ui.schedule.val()
        });

        this.model.save(null, {
            humanError: gettext('Не удалось сохранить станцию')
        });

        this.trigger('close');
    },

    unmap: function() {
        var text = [
            gettext('Удалить станцию'),
            '«',
            this.model.get('www_station').get('title'),
            '»',
            gettext('из мета-рейса')
        ].join(' ');

        if (!confirm(text + '?')) {
            return;
        }
        this.model.destroy();
    }
});

module.exports = StationForm;
