var Marionette = require('marionette'),
    _ = require('underscore'),
    BackboneYmaps = require('Backbone.Ymaps'),
    StationCollection = require('modules/red_stations/collection'),
    SidebarView = require('modules/red_stations/sidebarView'),
    StationPlacemark = require('modules/red_stations/placemark'),
    controls = require('modules/red_stations/controls'),
    ArmController = require('modules/arm');

var StationsController = Marionette.Controller.extend({
    controls: {
        select: controls.select,
        create: controls.create
    },

    initialize: function(options) {
        this.app = options.app;
        this.initValue = options.moduleOptions.packages.id;
        this.collection = new StationCollection();

        this.listenTo(this.app, 'thread:changed', this.setThread, this);
        this.listenTo(this.collection, 'reset', this._updateBounds, this);

        this._initContols();
        this._renderMapLayout();
    },

    // Api
    setThread: function(options) {
        options = options || {};

        var thread = options.model;

        this.collection.setThread(thread);
        if (thread && thread.get('id')) {
            this.collection.fetch({reset: true});
        } else {
            this.collection.reset();
        }
    },

    setInsertion: function(view, options) {
        !this.controls[options.type].isSelected() && this.controls[options.type].select();
        this.collection.setInsertion(options.position, options.model);
    },

    clearInsertion: function() {
        this.collection.clearInsertion();
    },

    addStation: function(wwwModel) {
        this.collection.create({
            'metaroute_id': this.app.currentThread.get('id'),
            lat: wwwModel.get('lat'),
            lon: wwwModel.get('lon'),
            'www_station': wwwModel
        });
    },

    openArm: function(options) {
        if (this.arm && this.arm.isOpen) {
            this.arm.close();
            return;
        }

        this.arm = new ArmController({
            collection: this.collection
        });
        this.arm.show();
    },

    // Private
    _initContols: function() {
        _.each(this.controls, function(control, key) {
            this.controls[key] = control(this);
        }, this);

        this.listenTo(this.app, 'thread:changed', function(options) {
            options = options || {};

            var method = 'disable';
            if (options.model && options.model.get('id')) {
                method = 'enable';
            }

            _.each(this.controls, function(control, key) {
                control[method]();
            });
        }, this);
    },

    _renderMapLayout: function() {
        var layer = new BackboneYmaps.CollectionView({
            geoItem: StationPlacemark,
            collection: this.collection,
            map: this.app.map
        });

        layer.render();
    },

    _updateBounds: function() {
        var bounds = this.collection.getBounds();
        if (!bounds) {
            var center = this.app.currentPackage.get('center');
            this.app.trigger('maps:setCenter', center);
            return;
        }

        this.app.trigger('maps:setBounds', bounds);
    },

    // Блоки
    selectBlock: function(region) {
        var view;

        this.listenTo(this.app, 'thread:changed', function(options) {
            if (!options || !options.model) {
                region.close();
                return;
            }

            view = new SidebarView({
                collection: this.collection
            });

            this.listenTo(view, 'itemview:changeInsertion', this.setInsertion, this);
            this.listenTo(view, 'openArm', this.openArm, this);

            region.show(view);
            this.arm && this.arm.close();
        }, this);
    }
});

module.exports = StationsController;
