var Backbone = require('Backbone'),
    WwwStationModel = require('modules/www_stations/model');

var StationModel = Backbone.RelationalModel.extend({
    relations: [{
        type: Backbone.HasOne,
        key: 'www_station',
        relatedModel: WwwStationModel
    }],

    defaults: {
        'arrival': 0,
        'departure': 0,
        'in_station_schedule': 'inherit',
        'is_fuzzy': 'inherit',
        'is_searchable_from': 'inherit',
        'is_searchable_to': 'inherit'
    }
});

module.exports = StationModel;
