var Marionette = require('marionette'),
    BemCompositeView = require('common/bemCompositeView'),
    StationView = require('modules/red_stations/sidebarItemView');


var EmptyView = Marionette.ItemView.extend({
    tagName: 'tr',
    attributes: {
        colspan: 3
    },
    template: '<td>' + gettext('Нет станций') + '</td>'
});

var StationsView = BemCompositeView.extend({
    template: require('templates/metastations-control'),

    itemView: StationView,
    emptyView: EmptyView,
    itemViewContainer: '.list',

    collectionEvents: {
        'reNumber': 'render'
    },

    ui: {
        armButton: '.js-arm'
    },

    events: {
        'click @ui.armButton': 'openArm'
    },

    onRender: function() {
        var _this = this,
            container = this.$el.find(this.itemViewContainer);
        
        this.sortable = new window.Sortable(
            container[0],
            {
                ghostClass: 'cell_ghost_yes',
                handle: '.js-title',
                draggable: 'tr',
                onUpdate: function(e) {
                    var id = +e.item.dataset.id,
                        model = _this.collection.get(id),
                        confirmText = [
                            gettext('Сохранить перемещение станции'),
                            model.get('www_station').get('title')
                        ].join(' ');

                    if (!confirm(confirmText + '?')) {
                        _this.render();
                        return;
                    }

                    var ids = [];
                    container.children('tr').each(function(i, tr) {
                        ids.push(+tr.dataset.id);
                    });
                    _this.collection.reorder(ids);
                }
            }
        );
    },

    openArm: function() {
        this.trigger('openArm', {
            collection: this.collection
        });
    }
});

module.exports = StationsView;
