var app = require('app'),
    Backbone = require('Backbone'),
    ThreadModel = require('modules/red_threads/model');

var ThreadCollection = Backbone.Collection.extend({
    model: ThreadModel,

    url: function() {
        return app.config.threadsUrl;
    },

    setPackage: function(package) {
        this.package = package;
    },

    fetch: function(options) {
        options = options || {};
        options.data = options.data || {};
        options.data['package_id'] = this.package.id;

        return Backbone.Collection.prototype.fetch.call(this, options);
    }
});

module.exports = ThreadCollection;
