var app = require('app'),
    _ = require('underscore'),
    Backbone = require('Backbone');

var ThreadModel = Backbone.Model.extend({
    urlRoot: function() {
        return app.config.threadsUrl;
    },

    parse: function(res) {
        // Маленький хак, чтобы не усложнять апи
        if ('validationStatus' in res) {
            app.trigger('alert:show', {
                msg: res['validationStatus'],
                type: 'error'
            });
            delete res['validationStatus'];
        } else {
            app.trigger('alert:hide');
        }
        return res;
    },

    getTitle: function() {
        return this.get('number') + ' - ' + this.get('title');
    },

    getTypeTitle: function() {
        var id = this.get('t_type_id');
        if (!id) {
            return '';
        }

        return app.config.app.config['t_types'][id].title;
    },

    clone: function(reverse, callback, context) {
        if (_.isFunction(arguments[0])) {
            context = callback;
            callback = reverse;
            reverse = false;
        }

        context = context || window;

        var options = {
            type: 'POST',
            dataType: 'json',
            url: _.result(this, 'url'),
            data: { action: 'clone', reverse: reverse },
            humanError: gettext('Не удалось скопировать мета-рейс'),
            success: function(res) {
                callback.call(context, new ThreadModel(res));
            }
        };

        return Backbone.ajax(options);
    }
});

module.exports = ThreadModel;
