var BemItemView = require('common/bemItemView'),
    selectItemViewMixin = require('common/selectItemViewMixin'),
    Base = BemItemView.extend(selectItemViewMixin);


var ThreadsView = Base.extend({
    template: require('templates/metathreads-control'),

    ui: {
        select: ['.js-thread', 'select'],
        editButton: ['.js-edit', 'button'],
        expandButton: ['.js-expand', 'button']
    },

    events: {
        'change @ui.select': 'onChange',
        'click @ui.editButton': 'onOpen',
        'click @ui.expandButton': 'onExpand'
    },

    initialize: function(options) {
        this.selectInit(options);
        this.on('changeSelected', this.updateButtons, this);
    },

    onRender: function() {
        this.updateOptions();
        this.updateButtons();
    },

    updateOptions: function() {
        var data = this.collection.map(function(thread) {
                return { item: 'option', value: thread.get('id') || thread.cid, content: thread.getTitle() };
            });

        this.ui.select.setOptions(data, this.value);
    },

    updateButtons: function() {
        if (!this.model || this.model.isNew()) {
            this.ui.editButton.setMod('disabled', 'yes');
        } else {
            this.ui.editButton.delMod('disabled');
        }

        if (!this.model || !this.model.get('route')) {
            this.ui.expandButton.setMod('disabled', 'yes');
        } else {
            this.ui.expandButton.delMod('disabled');
        }
    },

    onExpand: function() {
        window.open('/admin/www/route/' + this.model.get('route').id + '/', '_blank');
    },

    onOpen: function() {
        window.open('/admin/red/metaroute/' + this.model.get('id') + '/', '_blank');
    }
});

module.exports = ThreadsView;
