var _ = require('underscore'),
    app = require('app'),
    Backbone = require('Backbone'),
    GeoCollection = require('common/geoCollection'),
    RegionModel = require('modules/regions/model');


var RegionCollection = GeoCollection.extend({
    model: RegionModel,

    url: function() {
        return app.config.polygonsUrl;
    },

    parse: function(data, options) {
        var currentSettlement = app.currentSettlement,
            settlements = data.settlements || [];

        if (data.error) {
            app.trigger('alert:show', {
                msg: data.error,
                type: 'error'
            });
            options.remove = false;
        } else {
            app.trigger('alert:hide');
        }

        if (currentSettlement && !_.findWhere(settlements, {id: currentSettlement.id})) {
            settlements = [currentSettlement.attributes].concat(settlements);
        }

        return settlements;
    },

    getParams: function() {
        var center = app.map.getCenter(),
            bounds = app.map.getBounds();

        return {
            center: '' + center[0] + ',' + center[1],
            span: '' + (bounds[1][0] - bounds[0][0]) + ',' + (bounds[1][1] - bounds[0][1]),
            zoom: app.map.getZoom()
        };
    },

    fetch: function(options) {
        options = options || {};
        options.data = this.getParams();
        options.traditional = true;

        if (this._fetchXHR && this._fetchXHR.readyState !== 4) {
            this._fetchXHR.abort();
        }

        this._fetchXHR =
            Backbone.Collection.prototype.fetch.call(this, options);

        return this._fetchXHR;
    }
});

module.exports = RegionCollection;
