var app = require('app');

var typeToStyle = {
    1: 'train', // Поезд
    2: 'plane', // Самолёт
    3: 'bus',   // Автобус
    4: 'water', // Речной транспорт
    5: 'water', // Морской транспорт
    6: 'bus',   // Пригородный поезд
    7: 'plane', // Вертолёт
    8: 'bus',   // Городской транспорт
    9: 'bus',   // Псевдо-гортранс
    11: 'water' // Водный транспорт
};

function getIconStyle(model) {
    var settlement = model.get('settlement'),
        tType = model.get('t_type_id'),
        style = typeToStyle[tType];

    if (app.currentSettlement && settlement &&
        app.currentSettlement.id === settlement.id) {
        style += 'Selected';
    } else if (!settlement) {
        style += 'Unmapped';
    }

    if (model.get('hidden')) {
        style += 'Hidden';
    }

    return style;
}

module.exports = getIconStyle;
