var _ = require('underscore'),
    Backbone = require('Backbone'),
    GeoCollection = require('common/geoCollection'),
    WwwStationModel = require('modules/www_stations/model');


var WwwStationCollection = GeoCollection.extend({
    model: WwwStationModel,

    initialize: function() {
        // События моделей которые требуют перерисовки карты
        this.on('change:lon', this._triggerRedraw, this);
        this.on('change:lat', this._triggerRedraw, this);
        this.on('change:settlement', this._triggerRedraw, this);
        this.on('destroy', this._triggerRedraw, this);
    },

    _triggerRedraw: function() {
        this.trigger('redrawNeeded');
    }
});


var RegionModel = Backbone.Model.extend({
    initialize: function() {
        this.stations = new WwwStationCollection(this._stationData, {parse: true});

        this.on('remove', function () {
            this.stations.reset();
        }, this);

        // Пробрасываем дальше
        this.listenTo(this.stations, 'redrawNeeded', function() {
            this.trigger('redrawNeeded');
        }, this);
    },

    parse: function(resp, options) {
        // Ручка возвращает сразу и информацию о городе и о станциях

        this._stationData = resp.stations || [];
        _.each(this._stationData, function(station) {
            station.settlement.title = resp.title;
        });

        if (this.stations && resp.stations) {
            this.stations.set(this._stationData, {
                parse: true, remove: true, add: true, merge: true
            });
        }

        delete resp.stations;

        return resp;
    }
});


module.exports = RegionModel;
