var app = require('app'),
    WwwStationPlacemark = require('modules/www_stations/placemark'),
    getIconStyle = require('modules/regions/getIconStyle'),
    presets = require('modules/regions/presets'),
    StationForm = require('modules/regions/stationForm');

var RegionPlacemark = WwwStationPlacemark.extend({
    styles: presets.styles,

    modelEvents: {
        'hover': 'setHoverIcon',
        'unhover': 'updateIcon'
    },

    initialize: function(options) {
        this.updateIcon();

        this.geoObject.events.once('mouseenter', this.setHintContent, this);
        this.listenTo(app, 'settlement:changed', this.updateIcon, this);
    },

    getColor: function() {
        return getIconStyle(this.model);
    },

    setHintContent: function() {
        var settlementTitle = this.model.get('settlement') && this.model.get('settlement').title,
            majorityTitle = this.model.getMajorityTitle(),
            content = this.model.get('id') + '<br>' + this.model.get('title');

        if (settlementTitle) {
            content += '<br>(' + settlementTitle + ')';
        }

        if (majorityTitle) {
            content += '<br>Важность: ' + majorityTitle;
        }

        return content;
    },

    setHoverIcon: function() {
        this.setStyle('hover');
    },

    updateIcon: function () {
        this.setStyle(this.getColor());
    },

    onBalloonOpen: function() {
        this.balloonView = new StationForm({
            model: this.model
        });

        this.listenTo(this.balloonView, 'close', function() {
            this.geoObject.balloon.close();
        }, this);

        this.geoObject.options.unset('balloonContent');

        var balloonView = this.balloonView;
        var layout = ymaps.templateLayoutFactory.createClass('<div></div>', {
            build: function () {
                layout.superclass.build.call(this);
                this._element.appendChild(balloonView.render().el);
            }
        });

        this.geoObject.options.set('balloonContentLayout', layout);
    },

    onBalloonClose: function () {
        WwwStationPlacemark.prototype.onBalloonClose.apply(this);
        this.updateIcon();
    }
});


module.exports = RegionPlacemark;
