var _ = require('underscore');

function listNames() {
    var names = ['hover'];

    _.each(['train', 'plane', 'bus', 'water'], function (a) {
        _.each(['', 'Selected', 'Unmapped'], function (b) {
            _.each(['', 'Hidden'], function (c) {
                names.push(a + b + c);
            });
        });
    });

    return names;
}

function imagePreset(imageUrl) {
    var size = [20, 20];

    return {
        iconLayout: 'default#image',
        iconImageHref: imageUrl,
        iconImageSize: size,
        iconImageOffset: [-10, -10]
    };
}

var styles = _.object(_.map(listNames(), function (name) {
    return [name, 'admin#' + name];
}));

function addToStorage(staticUrl) {
    var imageUrl = staticUrl + 'images/';

    _.each(styles, function(preset, name) {
        ymaps.option.presetStorage.add(preset, imagePreset(imageUrl + name + '.svg'));
    });
}

module.exports = {
    styles: styles,
    imagePreset: imagePreset,
    addToStorage: addToStorage
};
