var _ = require('underscore'),
    cookie = require('jquery.cookie');


var imagesDirUrl = '/static/rasp/rainbow/';

var items = [
    { title: gettext('Автобусы'), tTypes: ['bus'], color: 'yellow', id: 'bus' },
    { title: gettext('Городской транспорт'), tTypes: ['urban'], color: 'black', id: 'urban' },
    { title: gettext('Поезда и пригородные поезда'), tTypes: ['train', 'local_train'], color: 'green', id: 'train' },
    { title: gettext('Псевдо-гортранс'), tTypes: ['pseudo-gortrans'], color: 'grey', id: 'pseudo-gortrans' },
    { title: gettext('Речной и морской транспорт'), tTypes: ['water'], color: 'blue', id: 'sea' },
    { title: gettext('Самолеты и вертолеты'), tTypes: ['plane', 'helicopter'], color: 'orange', id: 'plane' }
];
items = _.sortBy(items, 'title');


function WwwStationsControl(controller) {
    this.controller = controller;

    this.globalId = 'WwwStationsControl' + controller.options.adminType;
    document[this.globalId] = this;

    this.tTypes = controller.stationTypes;

    this.controlItems = _.map(items, this._makeListItem, this);

    this.control = new ymaps.control.ListBox({
        data: {
            title: gettext('Остановки'),
            content: gettext('Остановки')
        },
        items: this.controlItems
    });

    this.onChangeLayers();
}

_.extend(WwwStationsControl.prototype, {
    _makeListItem: function(item) {
        var cookieName = 'map_' + item.id + '_zoom',
            zoom = parseInt(cookie(cookieName), 10) || 10,
            controlItem;

        controlItem = new ymaps.control.ListBoxItem(
            {
                data: {
                    content: '<img src="' + imagesDirUrl + item.color + 'Dot.png' + '" /> ' +
                        '<input type="number" id="' + item.id + '" min="8" max="18" ' +
                        ' style="height: 22px; border: 1px solid #000; padding: 0; margin: 0;" ' +
                        ' onchange="document.' + this.globalId + '.setZoom(this);" value="' + zoom + '"' +
                        ' onclick="event.stopPropagation();"/> ' +
                        item.title,
                    id: item.id,
                    tTypes: item.tTypes,
                    cookieName: cookieName
                },
            }, {
                checkbox: true
            }
        );

        if (_.intersection(this.tTypes, item.tTypes).length) {
            controlItem.select();
        }

        controlItem.events.add(['select', 'deselect'], this.onChangeLayers, this);

        return controlItem;
    },

    onChangeLayers: function() {
        var selectedItems = _.filter(this.controlItems, function(item) {
            return item.isSelected();
        });

        this.tTypes = _.flatten(_.map(selectedItems, function(item) {
            return item.data.get('tTypes');
        }));

        this.controller.app.trigger('wwwStations:typeUpdate', this.tTypes);
    },

    setZoom: function (input) {
        var item = this.controlItems.find(function (i) { return i.data.get('id') === input.id; });
        $.cookie(item.data.get('cookieName'), input.value); //, { path: '/admin/' });

        this.controller.app.trigger('wwwStations:update');
    }
});


module.exports = function(controller) {
    var klass = new WwwStationsControl(controller);
    return klass.control;
};
