var app = require('app'),
    _ = require('underscore'),
    Backbone = require('Backbone');

var WwwStationModel = Backbone.RelationalModel.extend({
    urlRoot: function() {
        return app.config.wwwStationsUrl;
    },

    parse: function(data) {
        if (app.wwwSettlements && data.settlement && data.settlement.id) {
            var settlement = app.wwwSettlements.get(data.settlement.id);
            if (settlement) {
                data.settlement.title = settlement.get('title');
            }
        }

        return data;
    },

    validate: function(attrs, options) {
        var title = attrs.title || '';
        if (!title.trim()) {
            return gettext('Введите название остановки');
        }
    },

    getCoords: function() {
        return [this.get('lon'), this.get('lat')];
    },

    getAdminUrl: function() {
        return app.config.wwwStationAdminUrl + this.id;
    },

    getTypeTitle: function() {
        var id = this.get('t_type_id');
        if (!id) {
            return '';
        }

        return app.config['t_types'][id].title;
    },

    getMajorityTitle: function() {
        var id = this.get('majority_id'),
            majority;

        if (!id) {
            return '';
        }

        majority = app.config['station_majorities'][id];

        if (!majority) {
            return '';
        }

        return majority.title;
    },

    join: function(dst, options) {
        var self = this;

        options = options || {};
        options = _.extend({}, options, {
            type: 'POST',
            url: app.config.wwwStationsUrl + 'join/',
            dataType: 'json',
            data: { 'src_id': this.get('id'), 'dst_id': dst.get('id') },
            success: function (data) {
                self.trigger('destroy', self, self.collection);
            }
        });

        return Backbone.ajax(options);
    },

    defaults: {
        'title_ru': '',
        'title_uk': '',
        'title_tr': '',
        'title_en': ''
    }
});

module.exports = WwwStationModel;
