var app = require('app'),
    _ = require('underscore'),
    BemItemView = require('common/bemItemView'),
    makeOptions = require('makeOptions');

var StationForm = BemItemView.extend({
    template: require('templates/www-station-form-new'),

    ui: {
        country: ['.js-country', 'related-object'],
        region: ['.js-region', 'related-object'],
        city: ['.js-city', 'related-object'],

        title: ['.js-title', 'input'],

        majority: ['.js-majority', 'select'],

        cancel: ['.js-cancel', 'button'],
        create: ['.js-create', 'button']
    },

    events: {
        'click @ui.cancel': 'cancel',
        'click @ui.create': 'create',
    },

    modelEvents: {
        'invalid': 'onInvalid'
    },

    onRender: function() {
        var attrs = {
                country: app.currentPackage.get('country'),
                region: app.currentPackage.get('region')
            };

        // Страна/Регион
        _.each(attrs, function(v, name) {
            var attr = attrs[name] || {
                id: '',
                title: ''
            };

            this.ui[name].val(attr.id, attr.title);
        }, this);

        // Majority
        this.ui.majority.setOptions(makeOptions('station_majorities'), app.config.defaults.majority);
    },

    cancel: function() {
        this.trigger('close');
    },

    create: function() {
        var self = this;

        this.ui.title.delMod('error');

        this.model.set({
            title: this.ui.title.val(),
            'country_id': parseInt(this.ui.country.val() || 0, 10),
            'region_id': parseInt(this.ui.region.val() || 0, 10),
            'settlement_id': parseInt(this.ui.city.val() || 0, 10),
            'majority_id': parseInt(this.ui.majority.val() || 0, 10)
        });

        this.model.save(null, {
            humanError: gettext('Не удалось создать станцию'),
            success: function() {
                self.trigger('close');
            }
        });
    },

    onInvalid: function(model, error) {
        this.ui.title.setMod('error', 'yes');
        alert(error);
    }
});

module.exports = StationForm;
