var app = require('app'),
    WwwStationForm = require('modules/www_stations/stationForm'),
    BalloonPlacemark = require('common/balloonPlacemark');


var WwwStationPlacemark = BalloonPlacemark.extend({
    placemarkOptions: {
        draggable: true,
        balloonMinWidth: 400,
        balloonMaxWidth: 500,
        balloonMinHeight: 50,
        balloonMaxHeight: 520
    },

    events: {
        'mouseenter': 'onMouseEnter',
        'mouseleave': 'onMouseLeave',
        'balloonopen': 'onBalloonOpen',
        'balloonclose': 'onBalloonClose',
        'drag': 'dragStart',
        'dragend': 'dragEnd'
    },

    styles: {
        green: 'admin#greenDot',
        red: 'admin#redDot',
        yellow: 'admin#yellowDot',
        blue: 'admin#blueDot',
        orange: 'admin#orangeDot',
        black: 'admin#blackDot',
        grey: 'admin#greyDot',
        lightGrey: 'admin#lightGreyDot'
    },

    typeToStyle: {
        1: 'green',  // Поезд
        2: 'orange', // Самолёт
        3: 'yellow', // Автобус
        4: 'blue',   // Речной транспорт
        5: 'blue',   // Морской транспорт
        6: 'green',  // Пригородный поезд
        7: 'orange', // Вертолёт
        8: 'black',  // Городской транспорт
        9: 'lightGrey'    // Псевдо-гортранс
    },

    initialize: function(options) {
        this.setStyle(this.getColor());
    },

    getColor: function() {
        var tType = this.model.get('t_type_id');
        if (tType === app.modules.wwwStations.selectedType) {
            return 'red';
        }
        return this.typeToStyle[tType];
    },

    hintContent: function() {
        var settlementTitle = this.model.get('settlement') && this.model.get('settlement').title,
            content = this.model.get('id') + '<br>' + this.model.get('title');

        if (settlementTitle) {
            content += '<br>(' + settlementTitle + ')';
        }

        return content;
    },

    onBalloonOpen: function() {
        this.balloonView = new WwwStationForm({
            model: this.model
        });

        this.listenTo(this.balloonView, 'close', function() {
            this.geoObject.balloon.close();
        }, this);

        this.geoObject.options.unset('balloonContent');
        var balloonView = this.balloonView;
        var layout = ymaps.templateLayoutFactory.createClass('<div></div>', {
            build: function () {
                layout.superclass.build.call(this);
                this._element.appendChild(balloonView.render().el);
            }
        });

        this.geoObject.options.set('balloonContentLayout', layout);
    },

    onBalloonClose: function() {
        this.balloonView && this.balloonView.close();
        this.geoObject.properties.set('balloonContent', this.balloonContent);
    },

    dragStart: function(e) {
        var coords = e.get('target').geometry.getCoordinates(),
            closest = app.wwwCollection.findClosest(coords, 7, app.maps.preciseMode);

        // Рядом есть станция - объединение покажем цветом
        if (closest && closest !== this.model) {
            this.setStyle('green');
            this.closest = closest;
        } else {
            this.setStyle(this.getColor());
            this.closest = null;
        }
    },

    dragEnd: function(e) {
        if (this.closest) {
            this.setStyle(this.getColor());

            var text = [
                gettext('Объединить станцию'),
                this.model.get('id'),
                this.model.get('title'),
                gettext('с'),
                this.closest.get('id'),
                this.closest.get('title')
            ];

            if (!confirm(text.join(' ') + '?')) {
                this.updatePlacemarkCoordinates();
                return;
            }

            this.model.join(this.closest, {
                humanError: gettext('Не удалось объединить станции')
            });

            return;
        }

        if (!confirm(gettext('Переместить станцию') + ' ' + this.model.get('title') + '?')) {
            this.updatePlacemarkCoordinates();
            return;
        }

        this.updateModelCoordinates();
        this.model.save(null, {
            humanError: gettext('Не удалось переместить станцию') + ' ' + this.model.get('title')
        });
    }
});

module.exports = WwwStationPlacemark;
