function dotPreset(imageUrl, x, y) {
    var size = [11, 11];

    return {
        iconLayout: 'default#image',
        iconImageClipRect: [[size[0] * x, size[1] * y], [size[0] * (x + 1), size[1] * (y + 1)]],
        iconImageHref: imageUrl,
        iconImageSize: size,
        iconImageOffset: [-5, -5]
    };
}

function addToStorage(staticUrl) {
    var imageUrl = staticUrl + 'dots.png';

    ymaps.option.presetStorage.add('admin#redDot', dotPreset(imageUrl, 0, 0));
    ymaps.option.presetStorage.add('admin#yellowDot', dotPreset(imageUrl, 1, 0));
    ymaps.option.presetStorage.add('admin#greenDot', dotPreset(imageUrl, 2, 0));
    ymaps.option.presetStorage.add('admin#blueDot', dotPreset(imageUrl, 3, 0));
    ymaps.option.presetStorage.add('admin#orangeDot', dotPreset(imageUrl, 4, 0));
    ymaps.option.presetStorage.add('admin#blackDot', dotPreset(imageUrl, 5, 0));
    ymaps.option.presetStorage.add('admin#greyDot', dotPreset(imageUrl, 6, 0));
    ymaps.option.presetStorage.add('admin#lightGreyDot', dotPreset(imageUrl, 7, 0));
}

module.exports = {
    dotPreset: dotPreset,
    addToStorage: addToStorage
};
