var app = require('app'),
    HistoryController = require('geoHistory'),
    MaintenanceController = require('maintenance'),
    // Элементы управления карты
    infoControl = require('controls/info'),
    gorodaControl = require('controls/goroda'),
    // Модули
    SettlementController = require('modules/geo_settlement'),
    PolygonController = require('modules/regions');


var config = {
    // Urls
    wwwStationsUrl: '/admin/www_stations/api/stations/',
    polygonsUrl: '/admin/purple/api/polygons/',
    noSettlementStationsUrl: '/admin/purple/api/nosettlement/',
    // regionsUrl: '/admin/purple/api/regions/',
    settlementsUrl: '/admin/purple/api/settlements/',
    stationDetailsUrl: '/admin/purple/api/station/',

    // UI urls
    settlementAddUrl: '/admin/www/settlement/add/',
    wwwStationAdminUrl: '/admin/www/station/',

    // UI
    mapTools: [
        infoControl,
        gorodaControl
    ],
    controls: [],
    sidebarBlocks: [
        ['geo_settlement', 'selectBlock'],
        ['regions', 'selectBlock']
    ],
    moduleOptions: {
        packages: {},
        threads: {},
        'geo_settlement': {
            id: 213
        }
    },

    // defaults form values
    defaults: {
        majority: 4,
        stationType: 11,
        transportType: 3,
        supplier: 1
    }
};

app.addModules([
    { name: 'history', controller: HistoryController },
    { name: 'maintenance', controller: MaintenanceController },
    { name: 'geo_settlement', controller: SettlementController },
    { name: 'regions', controller: PolygonController }
]);

app.start(config);
