var app = require('app'),
    HistoryController = require('history'),
    MaintenanceController = require('maintenance'),
    // Элементы управления карты
    infoControl = require('controls/info'),
    gorodaControl = require('controls/goroda'),
    // Модули
    WwwStationsController = require('modules/www_stations'),
    PackagesController = require('modules/packages'),
    ThreadsController = require('modules/red_threads'),
    StationsController = require('modules/red_stations');


var config = {
    // Urls
    packagesUrl: '/admin/redmap/api/packages/',
    threadsUrl: '/admin/redmap/api/threads/',
    stationsUrl: '/admin/redmap/api/stations/',
    wwwStationsUrl: '/admin/www_stations/api/stations/',

    // UI urls
    packageAdminUrl: '/admin/red/package/',
    packageAddUrl: '/admin/red/package/add/',
    wwwStationAdminUrl: '/admin/www/station/',

    // UI
    mapTools: [
        infoControl,
        gorodaControl,
        'wwwStations.controls.stationsControl',
        'stations.controls.select',
        'stations.controls.create',
    ],
    sidebarBlocks: [
        ['packages', 'selectBlock'],
        ['threads', 'selectBlock'],
        ['stations', 'selectBlock'],
        ['threads', 'formBlock'],
    ],
    moduleOptions: {
        packages: {},
        threads: {}
    },

    // defaults form values
    defaults: {
        majority: 4,
        stationType: 11,
        transportType: 3,
        supplier: 1
    }
};

app.addModules([
    { name: 'history', controller: HistoryController },
    { name: 'maintenance', controller: MaintenanceController },
    { name: 'wwwStations', controller: WwwStationsController },
    { name: 'packages', controller: PackagesController },
    { name: 'threads', controller: ThreadsController },
    { name: 'stations', controller: StationsController }
]);

app.start(config);
