var _ = require('underscore'),
    Backbone = require('backbone'),
    Marionette = require('marionette');

var queryStringToHash = function(query) {
  var queryString = {};
  var vars = query.split('&');
  for (var i = 0; i < vars.length; i++) {
    var pair = vars[i].split('=');
    pair[0] = decodeURIComponent(pair[0]);
    pair[1] = decodeURIComponent(pair[1]);
    // If first entry with this name
    if (typeof queryString[pair[0]] === 'undefined') {
      queryString[pair[0]] = pair[1];
    // If second entry with this name
    } else if (typeof queryString[pair[0]] === 'string') {
      var arr = [ queryString[pair[0]], pair[1] ];
      queryString[pair[0]] = arr;
    // If third or later entry with this name
    } else {
      queryString[pair[0]].push(pair[1]);
    }
  }
  return queryString;
};

// Небольшой велосипед для парсинга и изменения урла
var HistoryController = Marionette.Controller.extend({
    initialize: function(options) {
        Backbone.history.start();

        this.app = options.app;
        this.settlementId = null;
        this.query = {};

        var initValues = this.parse();
        if (initValues[0]) {
            options.moduleOptions['geo_settlement'].id = initValues[0];
        }

        this.bind();
    },

    bind: function() {
        this.listenTo(this.app, 'settlement:changed', function(options) {
            this.setSettlement(options.model);
        }, this);
    },

    setSettlement: function(model) {
        if (model) {
            this.settlementId = model.get('id');
        } else {
            this.settlementId = null;
        }
        this.update();
    },

    parse: function() {
        var fragment = Backbone.history.getFragment(),
            parts = fragment.split('?'),
            path = parts[0],
            query = parts[1];

        if (path) {
            parts = path.split('/');
            this.settlementId = parts[0];
        }

        if (query) {
            this.query = queryStringToHash(query);
        }

        return [this.settlementId];
    },

    update: function() {
        var path = '';
        if (this.settlementId) {
            path += this.settlementId + '/';
        }

        var query = _.clone(this.query);
        query.center = this.app.map.getCenter().toString();
        query.zoom = this.app.map.getZoom();
        path += '?' + $.param(query);

        Backbone.history.navigate(path);
    }
});

module.exports = HistoryController;
