var _ = require('underscore'),
    Backbone = require('backbone'),
    Marionette = require('marionette');

var queryStringToHash = function(query) {
  var queryString = {};
  var vars = query.split('&');
  for (var i = 0; i < vars.length; i++) {
    var pair = vars[i].split('=');
    pair[0] = decodeURIComponent(pair[0]);
    pair[1] = decodeURIComponent(pair[1]);
    // If first entry with this name
    if (typeof queryString[pair[0]] === 'undefined') {
      queryString[pair[0]] = pair[1];
    // If second entry with this name
    } else if (typeof queryString[pair[0]] === 'string') {
      var arr = [ queryString[pair[0]], pair[1] ];
      queryString[pair[0]] = arr;
    // If third or later entry with this name
    } else {
      queryString[pair[0]].push(pair[1]);
    }
  }
  return queryString;
};

// Небольшой велосипед для парсинга и изменения урла
var HistoryController = Marionette.Controller.extend({
    initialize: function(options) {
        Backbone.history.start();

        this.app = options.app;
        this.packageId = null;
        this.threadId = null;
        this.query = {};

        var initValues = this.parse();
        options.moduleOptions.packages.id = initValues[0];
        options.moduleOptions.threads.id = initValues[1];

        this.bind();
    },

    bind: function() {
        this.listenTo(this.app, 'package:changed', function(options) {
            this.setPackage(options.model);
        }, this);
        this.listenTo(this.app, 'thread:changed', function(options) {
            this.setThread(options.model);
        }, this);
    },

    setPackage: function(model) {
        var newId = model.get('id');
        if (this.packageId === newId) {
            return;
        }
        this.packageId = newId;
        this.threadId = null;
        this.update();
    },

    setThread: function(model) {
        if (model) {
            this.threadId = model.get('id');
        } else {
            this.threadId = null;
        }
        this.update();
    },

    parse: function() {
        var fragment = Backbone.history.getFragment(),
            parts = fragment.split('?'),
            path = parts[0],
            query = parts[1];

        if (path) {
            parts = path.split('/');
            this.packageId = parts[0];
            this.threadId = parts[1];
        }

        if (query) {
            this.query = queryStringToHash(query);
        }

        return [this.packageId, this.threadId];
    },

    update: function() {
        var path = '';
        if (this.packageId) {
            path += this.packageId + '/';
            if (this.threadId) {
                path += this.threadId + '/';
            }
        }

        var query = _.clone(this.query);
        query.center = this.app.map.getCenter().toString();
        query.zoom = this.app.map.getZoom();
        path += '?' + $.param(query);

        Backbone.history.navigate(path);
    }
});

module.exports = HistoryController;
