var _ = require('underscore'),
    Backbone = require('backbone');


// Проверка состояния сервера и блокировка страницы
var MaintenanceController = function(options) {
    options.app.maintenance = this;

    var text = 'Вы попали в КГА (СГА) в боевой базе. Вы точно уверены, что хотите продолжить?';
    if (options.mainInstance && !confirm(gettext(text))) {
        window.location.href = '/admin/';
    }

    this.app = options.app;
    this.url = options.maintenanceStatusUrl;
    this.adminType = options.adminType;
    this.mainInstance = options.mainInstance;
    this.status = null;

    this.paranja = $('.paranja').bem('paranja');
    this.header = $('.header').bem('header');

    this.on('update_status', this.display, this);

    this.check();
    setInterval(_.bind(this.check, this), 5000);
};

_.extend(MaintenanceController.prototype, Backbone.Events, {
    check: function() {
        var self = this;

        $.get(this.url, { 'admin_type': this.adminType }, function(data) {
            self.updateStatus(data);
        });
    },

    updateStatus: function(status) {
        if (!this.status || _.isEqual(this.status, status)) {
            this.trigger('update_status', status);
        }
    },

    display: function(status) {
        var warningTextParts = [];

        if (this.mainInstance) {
            warningTextParts.push(gettext('Осторожно, боевая база!'));
        }

        if (status.state) {
            warningTextParts.push(status.state['verbose_name']);
        }

        if (status['warn_state']) {
            warningTextParts.push(this.getWarnText(status['warn_state']));
        }

        this.blockAdmin(status.state && status.state.block);

        if (warningTextParts.length) {
            this.header.showAlert(warningTextParts.join('<br />'));
        } else {
            this.header.hideAlert();
        }
    },

    getWarnText: function(state) {
        var seconds = state['remaining_seconds'] || 0,
            text = state['warn_text'];

        if (seconds) {
            var numParts = [];

            var hrs = Math.floor(seconds / 3600);
            seconds = seconds - hrs * 3600;
            if (hrs) {
                numParts.push(hrs);
            }

            var minutes = Math.floor(seconds / 60);
            numParts.push(minutes);

            seconds = seconds - minutes * 60;
            numParts.push(seconds);
            var formattedNums = _.map(numParts, function(num) {
                if (parseInt(num, 10) < 10) {
                    return '0' + num;
                }
                return num;
            });

            text += ' ' + formattedNums.join(':');
        }

        return text;
    },

    blockAdmin: function(block) {
        if (block) {
            this.paranja.open();
        } else {
            this.paranja.close();
        }
    }
});

module.exports = MaintenanceController;
