var app = require('app'),
    _ = require('underscore');

var cache = {},
    makeOptions = function(source, contentKey, valueKey) {
        return _.map(source, function(item) {
            return { item: 'option', value: item[valueKey], content: item[contentKey] };
        });
    };

// Генерация bemjson опций селекта из массива или объекта + кэш
module.exports = function(source, contentKey, valueKey) {
    contentKey = contentKey || 'title';
    valueKey = valueKey || 'id';

    if (_.isString(source)) {
        var cacheKey = source + contentKey + valueKey;
        if (!cache[cacheKey]) {
            source = app.config[source];
            cache[cacheKey] = makeOptions(source, contentKey, valueKey);
        }

        return cache[cacheKey];
    }

    return makeOptions(source, contentKey, valueKey);
};
