var _ = require('underscore'),
    Backbone = require('backbone');

// Плашка для отображения уведомлений
var Notificator = Backbone.View.extend({
    initialize: function(options) {
        this.dispatcher = options.dispatcher;

        this._notification = null;

        this.listenTo(this.dispatcher, 'alert:show', this.show, this);
        this.listenTo(this.dispatcher, 'alert:hide', this.hide, this);

        this.el = $('.notification').bem('notification');
    },

    show: function(options) {
        this._notification = options;

        if (options.autoRemove) {
            _.delay(_.bind(this.hide, this), options.autoRemove);
        }

        this._render();
    },

    hide: function() {
        this._notification = null;
        this._render();
    },

    _render: function() {
        var notification = this._notification,
            mods;

        if (!notification) {
            this.el.setContent('');
            this.el.setMod('visibility', 'hidden');

            return;
        }

        if (notification.type) {
            mods = { type: notification.type };
        }

        this.el.setContent(BEMHTML.apply({
            block: 'notification',
            elem: 'item',
            elemMods: mods,
            content: notification.msg
        }));

        this.el.delMod('visibility');
    }
});

module.exports = Notificator;
