if (!ymaps) {
    throw 'ymaps is required';
}

var geomap = {
    control: {},
    utils: {},
    initializer: {},
    data: {}
};


function extend(Child, Parent) {
    var F = function () {
    }
    F.prototype = Parent.prototype
    Child.prototype = new F()
    Child.prototype.constructor = Child
    Child.superclass = Parent.prototype
}

function mixin(dst, src) {
    // tobj - вспомогательный объект для фильтрации свойств,
    // которые есть у объекта Object и его прототипа
    var tobj = {}
    for (var x in src) {
        // копируем в dst свойства src, кроме тех, которые унаследованы от Object
        if ((typeof tobj[x] == "undefined") || (tobj[x] != src[x])) {
            dst[x] = src[x];
        }
    }
    // В IE пользовательский метод toString отсутствует в for..in
    if (document.all && !document.isOpera) {
        var p = src.toString;
        if (typeof p == "function" && p != dst.toString && p != tobj.toString &&
            p != "\nfunction toString() {\n    [native code]\n}\n") {
            dst.toString = src.toString;
        }
    }
}


geomap.ready = function (callback) {
    var readyState = new geomap.utils.readyState();
    $.each(geomap.initializer, function (i, initializer) {
        readyState.notReady();
        try {
            initializer(function () {
                readyState.ready();
            });
        } catch (e) {
            readyState.ready();
            throw e;
        }
    });
    readyState.onReadyOnce(callback);
};


geomap.Map = function (element, options) {
    var self = this;

    self.readyState = new geomap.utils.readyState();
    self.uidPrefix = element + '-';
    self.mapUid = self.genUid('geomap-map');
    self.titleProvider = options.titleProvider || self.defaultTitleProvider;

    var controlsUid = self.genUid('geomap-controls'),
        loaderUid = self.genUid('geomap-loader');

    self.options = options;
    self.element = $('#' + element);
    self.element.html(self._render(controlsUid, loaderUid));

    self.controlsContainer = $('#' + controlsUid);
    self.currentControlsContainer = self.controlsContainer;
    self._loader = $('#' + loaderUid);
    self.controls = {};
    self.urlParams = $.parseQuery();
    self._initMap();
};

geomap.Map.prototype = {

    defaultTitleProvider: function () {
    },

    genUid: function (postfix) {
        return this.uidPrefix + postfix;
    },

    resourceUrl: function (val) {
        var self = this,
            urlPrefix = self.options.resourceUrlPrefix || '/';
        return urlPrefix + val;
    },

    _render: function (controlsUid, loaderUid) {
        var self = this;
        return '<div class="Map-map">' +
            '  <div id="' + self.mapUid + '" style="height: 100%;"></div>' +
            '</div>' +
            '<div id="' + controlsUid + '" class="Map-controls">' +
            '</div>' +
            '<div id="' + loaderUid + '" style="position: absolute; top: 0; left: 0; right: 0; height: 100%;">' +
            '  <div class="Map-loader">' +
            '    <img src="' + self.resourceUrl('rasp/geomap/ajax-loader.gif') + '" >' +
            '  </div>' +
            '</div>';
    },

    _initMap: function () {
        var self = this,
            mapOptions = {};

        self._map = new ymaps.Map(self.mapUid, {
            center: mapOptions.center || [37.64, 55.76],
            zoom: mapOptions.zoom || 12,
            type: "yandex#map",
            behaviors: ["default", "scrollZoom", "drag", "dblClickZoom", "multiTouch"],
            controls: ['zoomControl', 'typeSelector']
        });

        self._behaviorInfo();

        self.events = self._map.events;

        var enabledOptions = self.options.controls || {};
        $.each(enabledOptions, function (i, options) {
            var style = "Map-controls-block";
            if (!$.isArray(options)) {
                options = [options];
                style= "Map-controls-block-default";

            }
            var id = "Map-controls-block-" + i;
            self.controlsContainer.append('<div class="' + style + '" id="' + id + '"></div>');
            self.currentControlsContainer = $('#' + id);
            try {
                $.each(options, function (j, controlOptions) {
                    self._processControl(controlOptions);
                });
            } finally {
                self.currentControlsContainer = self.controlsContainer;
            }
        });

        $.each(self.controls, function (i, control) {
            control.bind();
        });

        self.readyState.onReady(function (ready) {
            if (ready) {
                self._updateUrl();
            }
        });
        self.readyState.onReady(function (ready) {
            self._loader.toggle(!ready);
        });
        self._loader.toggle(!self.readyState.isReady());
    },

    _addControl: function (controlId) {
        var containerUid = controlId + "-container"
        this.currentControlsContainer.append('<div id="' + containerUid + '" class="row"></div>');
        return $("#" + containerUid);
    },

    _processControl: function (options) {
        var self = this,
            type = options.type,
            controlProvider = geomap.control[type];
        if (!controlProvider) {
            throw "Control '" + type + "' is not registered";
        }
        var control = new controlProvider(self, options);

        self.controls[control.id] = control;

        control.events.add('changed', function (event) {
            self.urlParams = $.extend(self.urlParams, control.getUrlParams());
        });
    },

    _updateUrl: function () {
        var self = this,
            params = $.extend({}, self.options.urlParams),
            title = self.titleProvider ? self.titleProvider.call(self) : '';
        $.each(self.controls, function (i, control) {
            params = $.extend(params, control.getUrlParams());
        });
        self.urlParams = {};
        $.each(params, function (k, v) {
            if (v && v != '') {
                self.urlParams[k] = v;
            }
        });
        document.title = title;
        window.history.replaceState(params, title, '?' + $.param(self.urlParams));
    },

    _behaviorInfo: function () {
        var self = this,
            map = self._map;

        function getInfo(e) {
            var position = e.get('coords');
            ymaps.geocode(position, { results: 1 }).then(function (res) {
                var firstGeoObject = res.geoObjects.get(0);

                map.balloon.open(position, firstGeoObject.properties.get('balloonContentBody'));
            });
        }

        var infoCursor,
            infoButton = new ymaps.control.Button({ data: { content: 'инфо' } });

        infoButton.events.add('select', function () {
            infoCursor = map.cursors.push('help');
            map.events.add('click', getInfo);
        });
        infoButton.events.add('deselect', function () {
            infoCursor && infoCursor.remove();
            map.events.remove('click', getInfo);
        });

        map.controls.add(infoButton);
    }
}
