/**
 * Базовый класс всех control-ов
 *
 * @param map карта, на которую добавляется control
 * @param options
 * @param uidPostfix
 * @constructor
 */
geomap.control.AbstractControl = function (map, options, defaultId) {
    var self = this;

    self.id = options.id || defaultId;
    if (!self.id) {
        throw "Id is not set for control type '" + self.constructor.name + "'";
    }
    self.map = map;
    self.options = options;
    self.uid = map.genUid(self.id);
    self.container = map._addControl(self.uid);
    self.events = new ymaps.event.Manager();
    self.readyState = new geomap.utils.readyState();
    self.readyState.onReady(function (ready) {
        if (ready) {
            self.map.readyState.ready();
        } else {
            self.map.readyState.notReady();
        }
    });

    self.objectTitleProvider = self.options.objectTitleProvider || self.defaultObjectTitleProvider;
    self.objectIdProvider = self.options.objectIdProvider || self.defaultObjectIdProvider;
};

mixin(geomap.control.AbstractControl.prototype, {

    bind: function () {
    },

    getUrlParams: function () {
        return {};
    },

    defaultObjectIdProvider: function (object) {
        return object && object.id ? object.id.toString() : null;
    },

    defaultObjectTitleProvider: function (object) {
        return object ? object.title : '';
    },

    _objectId: function (object) {
        var self = this;
        return self.objectIdProvider.call(self, object);
    },

    _objectTitle: function (object) {
        var self = this;
        return self.objectTitleProvider.call(self, object);
    }

});
