geomap.control.HasValue = function () {
    var self = this;

    self._currentId = null;
};

mixin(geomap.control.HasValue.prototype, {

    val: function (value, fire) {
        var self = this;
        if (value || value === null) {
            var id = self._objectId(value),
                currentId = self._currentId,
                currentValue = self.__getValueById(self._currentId);
            if (currentId != id) {
                if (self._beforeValueChange() === false || self._fireBeforeChanged(currentValue, value) === false) {
                    self._setValue(currentId);
                    return self.__getValueById(currentId);
                }
                self._currentId = id;
                self._setValue(id);
                self.refresh(true);
                self._fireChanged();
            } else if (fire) {
                self._fireChanged();
            }
        }
        return self.__getValueById(self._currentId);
    },

    getUrlParams: function () {
        var self = this;
        if (!self.id) {
            return {};
        }

        var value = self.val();
        if (!value) {
            return {}
        }

        var params = {};
        params[self.id] = self._objectId(value);
        return params;
    },

    _init: function () {
    },

    _beforeValueChange: function () {
    },

    _fireChanged: function () {
        var self = this;
        self.events.fire('changed', { value: self.val() });
    },

    _fireBeforeChanged: function (oldValue, newValue) {
        var self = this,
            canceled = false,
            event = {
                value: newValue,
                oldValue: oldValue,
                cancel: function () {
                    canceled = true;
                }
            };
        self.events.fire('beforeChange', event);
        return !canceled;
    },

    _defaultValue: function () {
        var self = this,
            id = self.id;

        if (id) {
            var key = self.map.urlParams[id],
                value = self.__getValueById(key);
            if (value) {
                return value;
            }
        }
    },

    _setValue: function (value) {
    },

    __getValueById: function (id) {
        var self = this;
        return self._getValueById ? self._getValueById(id) : null;
    }

});
