/**
 * Панель radio-кнопок
 * @param map
 * @param options
 * @param defaultTitle
 * @param id
 * @constructor
 */
geomap.control.RadioButtonPanel = function (map, options, defaultTitle, defaultId) {
    var self = this;

    options.title = options.title || defaultTitle;
    options.style = options.style || 'vertical';

    self.geoObjects = [];

    geomap.control.RadioButtonPanel.superclass.constructor.apply(self, [map, options, defaultId]);
    geomap.control.HasValue.prototype._init.call(self);

};

extend(geomap.control.RadioButtonPanel, geomap.control.ButtonPanel);

mixin(geomap.control.RadioButtonPanel.prototype, geomap.control.HasValue.prototype);

mixin(geomap.control.RadioButtonPanel.prototype, {

    defaultHandler: function (map, object) {
        var self = this;
        self.val(object);
    },

    _addGeoObject: function (geoObject) {
        var self = this;
        self.map._map.geoObjects.add(geoObject);
        self.geoObjects.push(geoObject);
    },

    _beforeRefresh: function () {
        var self = this;
        $.each(self.geoObjects, function (i, geoObject) {
            self.map._map.geoObjects.remove(geoObject);
        });
        self.geoObjects = [];
    }
});
