/**
 * Селект выбора нитки
 *
 * @param map
 * @param options
 * @constructor
 */
geomap.control.Thread = function (map, options) {
    var self = this;
    geomap.control.Thread.superclass.constructor.apply(self, [map, options, gettext('Нитка'), 'thread']);
};

extend(geomap.control.Thread, geomap.control.ListBox);

mixin(geomap.control.Thread.prototype, {

    bind: function () {
        var self = this;
        if (self.map.controls.package) {
            self.map.controls.package.events.add('changed', function (event) {
                self.refresh();
            });
        }
    }

});

mixin(geomap.control.buttonPanelPresets, {

    'thread#next': {
        title: gettext('-&gt;&nbsp;нитка'),
        handler: function (map, event) {
            geomap.utils.goToNextThread(map, geomap.utils.predicates.alwaysTrue);
        }
    },

    'thread#nextUnmapped': {
        title: gettext('Сохр. и дальше'),
        handler: function (map, event) {
            var threadPath = map.controls.threadPath;
            if (threadPath) {
                threadPath.save(false, true);
            }
            geomap.utils.goToNextThread(map, geomap.utils.predicates.unmapped);
        }
    }

});
