mixin(geomap.utils, {

    distance: function (p1, p2) {
        return ymaps.coordSystem.geo.distance(p1, p2);
    },

    toPoint: function (options) {
        return [options.lon, options.lat];
    },

    routeToPoints: function (route) {
        var points = [];

        route.getPaths().each(function (path) {
            $.each(path.getSegments(), function (i, segment) {
                points = points.concat(segment.getCoordinates())
            });
        });

        // если эелементов 2 и меньше - это значит маршрутизатор не смог построить маршрут
        return points.length <= 2 ? null : points;
    },

    buildIndex: function (objects, idProvider) {
        idProvider = idProvider || function (object) {
            return object ? object.id : null;
        };
        var index = {};
        $.each(objects, function (i, object) {
            index[idProvider(object)] = object;
        });
        return index;
    },

    goToNextSelectItem: function (select, predicate) {
        var currentValue = select.val(),
            objects = select.objects,
            nextIndex = objects.indexOf(currentValue) + 1;

        for (var i = nextIndex; i < objects.length; ++i) {
            var nextObject = objects[i];
            if (predicate(nextObject)) {
                select.val(nextObject);
                return true;
            }
        }

        return false;
    },

    goToNextPackage: function goToNextPackage(map) {
        if (!geomap.utils.goToNextSelectItem(map.controls.package, geomap.utils.predicates.alwaysTrue)) {
            window.alert(gettext('Это последний пакет'));
        }
    },

    goToNextThread: function (map, predicate) {
        var hasNextThread = geomap.utils.goToNextSelectItem(map.controls.thread, predicate);
        return hasNextThread || geomap.utils.goToNextPackage(map);
    },

    goToNextSegment: function (map, predicate) {
        var hasNextSegment = geomap.utils.goToNextSelectItem(map.controls.threadPath, predicate);
        if (hasNextSegment) {
            return true;
        }
        if (map.controls.thread) {
            return geomap.utils.goToNextThread(map, geomap.utils.predicates.alwaysTrue);
        }
        if (map.controls.station) {
            return geomap.utils.goToNextStation(map);
        }
        return true;
    },

    goToNextStation: function (map) {
        if (!geomap.utils.goToNextSelectItem(map.controls.station, geomap.utils.predicates.alwaysTrue)) {
            window.alert(gettext('Это последняя станция'));
        }
    },

    disable: function (element, disable) {
        if (disable) {
            $(element).removeAttr("disabled");
        } else {
            $(element).attr("disabled", "disabled")
        }
    },

    preparePathSegments: function (segments) {
        var idProvider = geomap.utils.functions.property('id'),
            fromStations = $.map(segments, geomap.utils.functions.property('station_from')),
            toStations = $.map(segments, geomap.utils.functions.property('station_to')),
            fromStationIndex = geomap.utils.buildIndex(fromStations, idProvider),
            toStationIndex = geomap.utils.buildIndex(toStations, idProvider),
            stationIndex = $.extend(fromStationIndex, toStationIndex);

        $.each(segments, function (j, s) {
            if (s.path) {
                s.path = $.parseJSON(s.path);
            }
            s.station_from = stationIndex[idProvider(s.station_from)];
            s.station_to = stationIndex[idProvider(s.station_to)];
        });
    },

    readyState: function () {
        var rs = this,
            self = {
                counter: 0,
                callbacks: [],
                onceCallbacks: [],

                assertCallback: function (callback) {
                    if (!$.isFunction(callback)) {
                        throw 'wrong argument'
                    }
                },

                processCallback: function (callback, ready) {
                    if ($.isFunction(callback)) {
                        try {
                            callback.call(rs, ready);
                        } catch (e) {
                            console.error(e)
                        }
                    }
                }
            };

        rs.isReady = function () {
            return self.counter == 0;
        };

        rs.ready = function () {
            if (!rs.isReady()) {
                --self.counter;
                if (rs.isReady()) {
                    var onceCallbacks = self.onceCallbacks;
                    self.onceCallbacks = [];
                    $.each(self.callbacks.concat(onceCallbacks), function (i, callback) {
                        self.processCallback(callback, true);
                    });
                }
            }
        };

        rs.notReady = function () {
            if (rs.isReady()) {
                $.each(self.callbacks, function (i, callback) {
                    self.processCallback(callback, false);
                });
            }
            ++self.counter;
        };

        rs.onReady = function (callback) {
            self.assertCallback(callback);
            self.callbacks.push(callback);
            if (!rs.isReady()) {
                self.processCallback(callback, false);
            }
            return {
                remove: function () {
                    var index = self.callbacks.indexOf(callback);
                    if (index >= 0) {
                        delete self.callbacks[index];
                    }
                }
            };
        };

        rs.onReadyOnce = function (callback) {
            self.assertCallback(callback);
            if (rs.isReady()) {
                self.processCallback(callback, true);
                return;
            }
            self.onceCallbacks.push(callback);
        };

        return rs;
    },

    predicates: {

        alwaysTrue: function (value) {
            return true;
        },

        alwaysFalse: function (value) {
            return false;
        },

        unmapped: function (value) {
            return value && value.unmapped;
        }
    },

    functions: {

        property: function (propertyName) {
            return function (object) {
                return object ? object[propertyName] : null;
            }
        }

    }
});
