
if (MAIN_INSTANCE && !confirm(gettext('Вы попали в КГА (СГА) в боевой базе. Вы точно уверены, что хотите продолжить?'))) {
    window.location = "/admin/";
}

var adminBlockChecker = {
    checkBlocker: function() {
        var self = this;
        $.get(MAINTENACE_STATUS_URL, {'admin_type': ADMIN_TYPE}, function(status) {
            self.setStatus(status);
        });
    },

    setStatus: function(status) {
        this.hideAlert();
        this.releaseBlock();

        this.trigger('update_status', status);

        var warningTextParts = [];

        if (MAIN_INSTANCE) {
            warningTextParts.push("Осторожно, боевая база!");
        }

        if (status.state) {
            warningTextParts.push(status.state.verbose_name);

            if (status.state.block) {
                this.blockAdmin();
            }
        }

        if (status.warn_state) {
            warningTextParts.push(this.getWarnText(status.warn_state));
        }

        if (warningTextParts.length) {
            this.showAlert(warningTextParts.join('<br />'));
        }

        mapPageFixBodyHeight();
    },

    showAlert: function(text) {
        $('#admin_block_alert').html(text).show();
    },

    hideAlert: function() {
        $('#admin_block_alert').hide();
    },

    getWarnText: function(state) {
        var seconds = state.remaining_seconds || 0;
        var text = state.warn_text;

        if (seconds) {
            var numParts = [];

            var hrs = Math.floor(seconds / 3600);
            seconds = seconds - hrs * 3600;
            if (hrs) numParts.push(hrs);

            var minutes = Math.floor(seconds / 60);
            numParts.push(minutes);

            seconds = seconds - minutes * 60;
            numParts.push(seconds);
            var formattedNums = _.map(numParts, function(num) {
                return _.str.sprintf('%02d', num);
            });

            text += ' ' + formattedNums.join(':');
        }

        return text;
    },

    releaseBlock: function() {
        $('#body_wrapper').show();
    },
    blockAdmin: function() {
        $('#body_wrapper').hide();
    }
};

MicroEvent.mixin(adminBlockChecker);

$(function() {
    adminBlockChecker.checkBlocker();
    var boundFunc = _.bind(adminBlockChecker.checkBlocker, adminBlockChecker);
    setInterval(boundFunc, 5000);
});
