function initSettings(inputs, csrf_token) {
    inputs.each(function (input) {
        input = $(this);
        var saveBtn = $('<button type="button" class="button button-big">save</button>');
        saveBtn.data('input_id', input.attr('id'));

        var saveBtnTd = $('<td/>');
        saveBtnTd.append(saveBtn);
        input.closest('tr').append(saveBtnTd);

        saveBtn.on('click', function(e) {
            var input = $('#' + $(this).data('input_id'));
            input.animate({opacity: 0.1});

            var input_err_id = input.attr('name') + '__error';
            $('#' + input_err_id).remove();  // скрываем элемент с ошибкой, если был

            var value = input.val();
            if(input.attr('type') === 'checkbox') {
                value = input.prop('checked');
            }

            $.ajax({
                url: 'dynamic_settings/save_setting/',
                data: $.param({changedField: input.attr('name'), newFieldValue: value}),
                type: "post",
                headers: {'X-CSRFToken': csrf_token},
                timeout: 5000
            }).always(function(){
                input.animate({opacity: 1});
            }).fail(function (response) {
                var err_el = '<div id="' + input_err_id + '" style="color: red">' + response.responseText + '</div>';
                input.after(err_el);
            });
        });
    });
}
