geomap.ready(function () {

    var map = new geomap.Map('geomap', {

        titleProvider: function () {
            var parts = [this.controls.station.val(), this.controls.threadPath.val()];

            return $.map(parts,function (part) {
                return part ? part.title : null;
            }).join(' | ') + ' - Лимонный геоадмин';
        },
        urlParams: {
            mode: 'moved_stations'
        },
        resourceUrlPrefix: staticUrl,
        controls: [
            { type: 'StationLayers' },
            {
                id: 'station',
                type: 'ListBox',
                label: gettext(gettext('Станция')),
                refresh: true,
                dataProvider: function (map, callback) {
                    $.getJSON('/admin/lime/moved_stations/', {}, function (data) {
                        callback(data.stations);
                    });
                }
            },
            {
                id: 'buttons-nav',
                type: 'ButtonPanel',
                title: gettext('Навигация'),
                buttons: [
                    {
                        title: gettext('-&gt;&nbsp;станция'),
                        handler: function (map, event) {
                            if (!geomap.utils.goToNextSelectItem(map.controls.station, geomap.utils.predicates.alwaysTrue)) {
                                window.alert(gettext('Это последняя станция'));
                            }
                        }
                    },
                    { preset: 'threadPath#next' },
                    { preset: 'threadPath#nextUnmapped' },
                    { preset: 'threadPath#selectThread'}
                ]
            },
            {
                id: 'buttons-actions',
                type: 'ButtonPanel',
                title: gettext('Действия'),
                presets: ['threadPath#save', 'threadPath#reset', 'threadPath#route', 'threadPath#remove']
            },
            {
                type: 'ThreadPath',
                dataProvider: function (map, callback) {
                    var station = map.controls.station.val();
                    if (!station) {
                        callback([]);
                        return;
                    }

                    $.getJSON('/admin/lime/station/' + station.id + '/segments/', {}, function (data) {
                        geomap.utils.preparePathSegments(data.segments);
                        callback(data.segments);
                    });
                },
                station: {
                    placemark: {
                        optionsProvider: function (station) {
                            return {
                                draggable: true,
                                hideIconOnBalloonOpen: false,
                                iconLayout: 'default#image',
                                iconImageSize: [21, 21],
                                iconImageOffset: [-10, -10],
                                iconImageHref: staticUrl + 'rasp/rainbow/greenDotBig.png'
                            };
                        }
                    }
                }
            }
        ]

    });

    var threadPath = map.controls.threadPath;
    map.controls.station.events.add('changed', function (event) {
        threadPath.refresh();
    });

    map.controls.station.events.add('beforeChange', function (event) {
        if (!threadPath.checkChanges()) {
            event.originalEvent.cancel();
        }
    });

    map.controls.station.events.add('changed', function (event) {
        var val = map.controls.station.val();
        if (val) {
            map.controls.stationLayers.setRequiredTransportType(val.t_type_code);
        }
    });

    map.controls.station.refresh();

});
