geomap.ready(function () {

    var map = new geomap.Map('geomap', {

        titleProvider: function () {
            var parts = [this.controls.package.val(), this.controls.thread.val(), this.controls.threadPath.val()];

            return $.map(parts,function (part) {
                return part ? part.title : null;
            }).join(' | ') + ' - Лимонный геоадмин';
        },
        urlParams: {
            mode: 'threads'
        },
        resourceUrlPrefix: staticUrl,
        controls: [
            { type: 'StationLayers' },
            [
                { type: 'Package' }
            ],
            [
                {
                    type: 'Thread',
                    refresh: true,
                    dataProvider: function (map, callback) {
                        var p = map.controls.package.val();
                        if (!p) {
                            callback([]);
                            return;
                        }
                        $.getJSON('/admin/lime/threads/' + p.id + '/', {}, function (data) {
                            callback(data.meta_threads);
                        });
                    }
                },
                {
                    id: 'buttons-thread-nav',
                    type: 'ButtonPanel',
                    presets: ['threadPath#saveAll', 'thread#nextUnmapped']
                }
            ],
            [
                {
                    id: 'buttons-threadPath-actions',
                    type: 'ButtonPanel',
                    title: gettext('Действия с никой/сегментом'),
                    presets: ['threadPath#reset', 'threadPath#route', 'threadPath#remove']
                },
                {
                    id: 'buttons-threadPath-actions2',
                    type: 'ButtonPanel',
                    presets: [ 'threadPath#save', 'threadPath#nextUnmapped', 'threadPath#selectThread']
                },
                {
                    type: 'ThreadPath',
                    dataProvider: function (map, callback) {
                        var thread = map.controls.thread.val();
                        if (!thread) {
                            callback([]);
                            return;
                        }

                        $.getJSON('/admin/lime/thread/' + thread.id + '/segments/', {}, function (data) {
                            geomap.utils.preparePathSegments(data.segments);
                            $.each(data.segments, function (i, segment) {
                                segment.title = (i + 1) + "->" + (i + 2) + ": " + segment.title;
                            });
                            callback(data.segments);
                        });
                    },
                    station: {
                        placemark: {
                            optionsProvider: function (station) {
                                return {
                                    draggable: true
                                };
                            },

                            iconContentProvider: function (station) {
                                var self = this,
                                    number = 2;

                                if (self.objects[0].station_from == station) {
                                    return 1;
                                }
                                for (var i = 0; i < self.objects.length; ++i) {
                                    if (self.objects[i].station_to == station) {
                                        return i + 2;
                                    }
                                }
                                return -1;
                            }
                        }
                    }
                }
            ]
        ]
    });

    var threadPath = map.controls.threadPath;

    map.controls.thread.events.add('changed', function (event) {
        threadPath.refresh();
    });

    map.controls.package.events.add('beforeChange', function (event) {
        if (!threadPath.checkChanges()) {
            event.originalEvent.cancel();
        }
    });

    map.controls.package.events.add('changed', function (event) {
        var val = map.controls.package.val();
        if (val) {
            map.controls.stationLayers.setRequiredTransportType(val.t_type_code);
        }
    });

    map.controls.thread.events.add('beforeChange', function (event) {
        if (!threadPath.checkChanges()) {
            event.originalEvent.cancel();
        }
    });

    threadPath.events.add('changed', function (event) {
        var title = threadPath.val() ? 'Действия с сегментом' : 'Действия с ниткой';
        map.controls['buttons-threadPath-actions'].title(title);
    });

    map.controls.package.refresh();

});
