function Goroda(map, wwwStations) {
    var self,
        poly=null,
        timeoutHandler=null,
        $dashBoard=$('<div class="goroda-dashboard">' +
                    '<h6>' + gettext('Станциям') + ':</h6>' +
                    '<ul class="free-stations"></ul>' +
                    '<h6>' + gettext('Назначить город') + ':</h6>' +
                    '<table class="settlements-actions"></table>' +
                    '</div>'),
        $settlements = $('.settlements-actions', $dashBoard),
        $free_stations = $('.free-stations', $dashBoard);

    $dashBoard.css('display', 'none');
    $(document.body).append($dashBoard);

    function later(fn, time) {
        if(timeoutHandler) {
            clearTimeout(timeoutHandler);
            timeoutHandler=null;
        }
        timeoutHandler = setTimeout(function(){
            fn();
            timeoutHandler=null;
        }, time);
    }

    function showDashBoard(stations, settlements) {
        $('LI', $free_stations).remove();
        $('TR', $settlements).remove();

        settlements.sort(function(c, j) {
            return wwwStations.getSettlementTitleById(c) > wwwStations.getSettlementTitleById(j)
        });

        stations.sort(function(c, j) {
            return c.title > j.title
        });

        if(settlements.length > 0) {
            $.each(settlements, function(j, id) {
                $settlements.append($('<tr><td><input type="button" class="set-settlement" data-id="' + id + '" value="' + wwwStations.getSettlementTitleById(id)  + '"></td></tr>'));
            });
        }
        $settlements.append($('<tr><td>' +
            '<input type="hidden" id="station-city" name="settlement" class="vForeignKeyRawIdAdminField" value="">' +
            '<input type="button" class="select-settlement" value="' + gettext('Выбрать город') + '" id="lookup_station-city" class="related-lookup" href="/admin/www/settlement/?t=id">' +
            '<strong id="station-city-title"></strong>' +
            '</td></tr>'));

        // Выбрать город
        $('#lookup_station-city', $settlements).click(function(){
            return showRelatedObjectLookupPopup(this, function(settlement_id) {
                if(settlement_id) {
                    $.getJSON('/admin/redmap/info/settlement/' + settlement_id + '/', function(info) {
                        var sids = [],
                            settlement_title = info.title;
                        if(settlement_title) {
                            if(!confirm(gettext('Действительно привязать станции к городу') + ' ' + settlement_title + ' ?')) {
                                return;
                            }
                            $.each(stations, function(j, s) {
                                sids.push(s.id);
                            });
                            $.post('/admin/redmap/www_stations/goroda/',
                                {'settlement_id': settlement_id, 'sids': sids},
                                function(data) {
                                    if(data.status == 'ok') {
                                        statusBar.say(gettext('Станции успешно привязаны к городу') + ' ' + settlement_title);
                                        wwwStations.redraw();
                                    } else {
                                        alert(gettext('Ошибка. не смогли назначить город станциям'));
                                    }
                                }, 'json'
                            );

                            self.close();
                            // Начинаем с начала
                            self.open();
                        }
                    });
                }
            });
        });

        if(stations.length > 0) {
            $.each(stations, function(j, s) {
                $free_stations.append($('<li><a href="/admin/www/station/' + s.id + '/" target="_blank">' + s.id + '</a> &nbsp; ' + s.title + '</li>'));
            });

            $('INPUT[type=button].set-settlement', $settlements).click(function() {
                var settlement_id = $(this).attr('data-id'),
                    sids = [],
                    settlement_title = wwwStations.getSettlementTitleById(settlement_id);
                if(!confirm(gettext('Действительно привязать станции к городу') + ' ' + settlement_title + ' ?')) {
                    return;
                }

                $.each(stations, function(j, s) {
                    sids.push(s.id);
                });
                $.post('/admin/redmap/www_stations/goroda/',
                    {'settlement_id': settlement_id, 'sids': sids},
                    function(data) {
                        if(data.status == 'ok') {
                            statusBar.say(gettext('Станции успешно привязаны к городу') + ' ' + settlement_title);
                            wwwStations.redraw();
                        } else {
                            alert(gettext('Ошибка. не смогли назначить город станциям'));
                        }
                    }, 'json'
                );

                self.close();
                // Начинаем с начала
                self.open();
            });

        } else {
            $free_stations.append($('<li>' + gettext('Ни одной станции без города') + '</li>'));
            $('INPUT', $settlements).attr('disabled', 'disabled');
        }

        if(stations.length > 0 || settlements.length > 0) {
            $dashBoard.fadeIn();
        }
    };

    function hideDashBoard() {
        $dashBoard.fadeOut();
    };

    function createPoly() {

        poly = new ymaps.Polygon(
            [[]], {

            }, {
                strokeWidth: 3,
                strokeColor: '#f00',
                stopDrawingByDblClick: true,
                drawOver: true
            }
        );

        poly.events.add('geometrychange', function (e) {
            hideDashBoard();

            if(!poly.geometry.getCoordinates().length) {
                return;
            }

            later(function() {
                var stations = [],
                    settlements = [],
                    _settlements = {};

                wwwStations.each(function(j, www) {
                    if(poly.geometry.contains([www.lon, www.lat])) {
                        if(www.settlement) {
                            _settlements[www.settlement.id] = true;
                        } else {
                            stations.push(www);
                        }
                    }
                });

                $.each(_settlements, function(k) {
                    settlements.push(k);
                });

                showDashBoard(stations, settlements);

            }, 618);
        });

        map.geoObjects.add(poly);
        poly.editor.startDrawing();

    };

    function desintegratePoly() {
        map.geoObjects.remove(poly);
        poly = null;
    };

    self = {
        open : function() {
            createPoly();
        },

        close : function() {
            desintegratePoly();
            hideDashBoard();
        }
    };
    return self;
}
