function WwwStation(s) {
    var self,
        styles = {
            initial : {
                iconImageSize: [11, 11],
                iconImageOffset: [-5, -5]
            },
            red : {
                iconImageSize: [11, 11],
                iconImageOffset: [-5, -5],
                iconImageHref: mediaUrl + 'rainbow/redDot.png'
            },
            green : {
                iconImageSize: [11, 11],
                iconImageOffset: [-5, -5],
                iconImageHref: mediaUrl + 'rainbow/greenDot.png'
            },
            grey : {
                iconImageSize: [11, 11],
                iconImageOffset: [-5, -5],
                iconImageHref: mediaUrl + 'rainbow/greyDot.png'
            },
            orange : {
                iconImageSize: [11, 11],
                iconImageOffset: [-5, -5],
                iconImageHref: mediaUrl + 'rainbow/orangeDot.png'
            },
            yellow : {
                iconImageSize: [11, 11],
                iconImageOffset: [-5, -5],
                iconImageHref: mediaUrl + 'rainbow/yellowDot.png'
            },
            blue : {
                iconImageSize: [11, 11],
                iconImageOffset: [-5, -5],
                iconImageHref: mediaUrl + 'rainbow/blueDot.png'
            },
            black : {
                iconImageSize: [11, 11],
                iconImageOffset: [-5, -5],
                iconImageHref: mediaUrl + 'rainbow/blackDot.png'
            },
            bigGreen : {
                iconImageSize: [21, 21],
                iconImageOffset: [-10, -10],
                iconImageHref: mediaUrl + 'rainbow/greenDotBig.png'
            }
        };

        typeToStyle = {
            '1': 'green',  // Поезд
            '2': 'orange', // Самолёт
            '3': 'yellow', // Автобус
            '4': 'blue',   // Речной транспорт
            '5': 'blue',   // Морской транспорт
            '6': 'green',  // Пригородный поезд
            '7': 'orange', // Вертолёт
            '8': 'black',  // Городской транспорт
            '9': 'grey'    // Псевдо-гортранс
        };

    self = {

        setIconStyleProperties : function(style) {
            if(!self.pm || !style) { return; }

            $.each(style, function(k, v) {
                self.pm.options.set(k, v);
            });
        },

        setStyle : function(styleName) {
            self.setIconStyleProperties(styles[styleName]);
        },

        setRightStyle : function() {
            self.setStyle(self.whatStyle());
        },

        whatStyle : function() {
            // Станции активного вида транспорта (вида транспорта того пакета с которым работаем) делать одного цвета - ярко-красного
            return self.t_type_id == getActiveTTypeID() ? 'red' : typeToStyle[self.t_type_id];
        },

        destruct : function() {
            self.pmDelete();
        },

        pmCreate : function() {
            var options,
                settlement_title,
                hintContent;

            if(!self.pm && self.lon && self.lat) {
                options = {
                    draggable: true,
                    hideIconOnBalloonOpen: false,
                    iconLayout: 'default#image'
                };

                settlement_title = (wwwStations.getSettlementTitleById(self.settlement && self.settlement.id) || '');
                hintContent = self.id + '<br />' + self.title + (settlement_title && ('<br />(' + settlement_title + ')') || '');

                self.pm = new ymaps.Placemark(
                    [self.lon, self.lat], {
                        hintContent: hintContent,
                        balloonContent: '<div><table>' +
                            '<tr><td>' + self.id + '</td></tr>' +
                            '<tr><td>' + self.title + '</td></tr>' +
                            '<tr><td><a href="/admin/www/station/'+self.id+'" target="_blank">' + gettext('Редактировать в геоадмине') + '</a></td></tr>' +
                            '<tr><td>' + wwwStations.majorityChanger(self.id, self.majority_id) + '</td></tr>' +
                            '</table></div>'
                    },
                    options
                );

                self.setRightStyle();

                self.pm.station_id = self.id;

                self.pm.events.add('click', function(pme) {
                    $callbacks.trigger('click', {'pme':pme, 'station':self});
                });

//            // ===============================================================
//            // Перетаскивание станций нашей базы

                self.pm.events.add('drag', function () {
                    $callbacks.trigger('stationDrag', {station: self});
                });

                self.pm.events.add('dragend', function () {
                    $callbacks.trigger('stationDragEnd', {station: self});
                });

                map.geoObjects.add(self.pm);
            }
        },

        pmUpdate : function() {
            self.pmDelete();
            self.pmCreate();
//            if(self.pm) {
//                self.pm.geometry.setCoordinates([self.lon, self.lat]);
//                self.setRightStyle();
//            } else {
//                self.pmCreate();
//            }
        },

        pmDelete : function() {
            if (self.pm) {
                map.geoObjects.remove(self.pm);
                self.pm = null;
            }
        },

        update : function(s) {
            if(typeof(s) != 'undefined' && !$.isEmptyObject(s)) {
                $.each(s, function(j, v) {
                    self[j] = v;
                });
            };

            self.pmUpdate();
        },

        hide : function() {
            if(self.pm) {
                self.pm.options.set('visible', false);
            }
        },

        show : function() {
            if(self.pm) {
                self.pm.options.set('visible', true);
            }
        },

        changeMajority : function(majority_id) {
            $.post('/admin/redmap/www_station/change_majority/', {'station_id': self.id, 'majority_id': majority_id},
                function(data) {
                    if(data.status == 'ok') {
                        self.update({majority_id: majority_id});
                        $callbacks.trigger('majorityChanged', {'www_station':self});
                    } else {
                        alert(gettext('Не удалось сменить важность станции'));
                    }
                }
            );
        }

};

    self.update(s);

    return self;
}
